!
!   TestErf
!     Main test routine for all types of error functions and the
!     corresponding algorithms including input and output
!   Remark:
!     Compiler independend menu driven test program for Error Functions
!
!   Implementation, adjustments and/or extensions by Thomas Hoering,
!     last modification: 31. January 2025
!
    program TestErf
!
    use kinds, only: ik, rk, lk
    use mdef                                        ! VOLUME 1 and 2
    use mErf;       use mErfc;       use mErfcx     ! VOLUME 1 only
!   use mErfinv;    use mErfcinv;    use mErfcxinv  ! VOLUME 2 only
!
    implicit none
!
!   local variables and parameter
    logical  (lk)               :: ok            ! true/false exit program
    real     (rk)               :: f             ! function result
    integer  (ik)               :: it            ! number of iterations
    integer  (ik)               :: func          ! selected  function number
    integer  (ik)               :: alg           ! selected  algorithm number
    character(Len = 56)         :: w(1:100)      ! algorithm text
    integer  (ik)               :: m             ! algorithm numb. in w(1:100)
    integer  (ik), parameter    :: maxrow   = 39 ! row number of output
    integer  (ik)               :: i, k          ! do ...
!
!   parameter and variables for the test data
    real     (rk)               :: x             ! function input normal or
!                                                           output inverse
    real     (rk)               :: y             ! function output normal or
!                                                           input inverse
    real     (rk)               :: taberf        ! tabled erf... result
!
!   maximum number of rows in the table of "DatError"
    integer  (ik), parameter    :: maxerf        = 47_ik
    integer  (ik), parameter    :: maxerfc       = 65_ik
    integer  (ik), parameter    :: maxerfcx      = 78_ik
    integer  (ik), parameter    :: maxerfinv     = 31_ik
    integer  (ik), parameter    :: maxerfcinv    = 59_ik
    integer  (ik), parameter    :: maxerfcxinv   = 74_ik
!
!
!-----------------------------------------------------------------------------
!   Volume 1 and Volume 2: Main Menu Steering
!
    call Startinfo( )                                ! Start Screen
!
    ok = .false.
    do while ( .not. ok )                            ! Main menu
       call Menu( func, w, m, alg )
!                 func := selected function
!                       w := array with text of algorithms/instruction
!                          m := number of elements in w
!                             alg := selected algorithm
!
!-----------------------------------------------------------------------------
!      Volume 1: Error Function, y = erf( x )
!
       if( func == 1_ik ) then                       ! 1: erf(x)
           call Out1( func, w(alg) )                 ! headlines
           do k = 1_ik, maxerf, 1_ik                 ! do... data points
              call DatError( func, k, x, taberf )    ! get taberf=erf(x)
              do i = 1_ik, m-1_ik, 1_ik              ! do... algorithm
                 if( i /= alg ) cycle                ! not alg => cycle
                 it = 0_ik                           ! zero iterations
                 select case( i )                    ! select algorithm
                  case(  1 ); f = erfIntrinsic    ( x     )  ! High
                  case(  2 ); f = erfStrecok      ( x     )  ! High
                  case(  3 ); f = erfCody         ( x     )  ! High
                  case(  4 ); f = erfSchonfelder  ( x     )  ! High
                  case(  5 ); f = erfSlatec       ( x     )  ! High
                  case(  6 ); f = erfSun          ( x     )  ! High
                  case(  7 ); f = erfOoura8a      ( x     )  ! High
                  case(  8 ); f = erfOoura8b      ( x     )  ! High
                  case(  9 ); f = erfOoura16      ( x     )  ! High
                  case( 10 ); f = erfDia          ( x     )  ! High
                  case( 11 ); f = erfAStegun      ( x     )  ! Low
                  case( 12 ); f = erfMenzel       ( x     )  ! Low
                  case( 13 ); f = erfTANH         ( x     )  ! Low
                  case( 14 ); f = erfWinitzki     ( x     )  ! Low
                  case( 15 ); f = erfPade         ( x     )  ! Low
                  case( 16 ); f = erfSE           ( x, it )  ! SE
                  case( 17 ); f = erfSEasymp      ( x, it )  ! SE asymp.
                  case( 18 ); f = erfCF           ( x, it )  ! CF
                  case default; write(*,'("Algorithm not found")')
                 end select
                 call Out2( k, x, taberf, f, it )    ! output data result
              end do                                 ! end do i
              if( k == maxrow ) then                 ! max. number lines
                  call ScrBreak( "S" )               ! new page
                  call Out1( func, w(alg) )          ! new headlines
              end if
           end do                                    ! end do k
           call ScrBreak( "S" )                      ! (S)hort line, continue
       end if                                        ! end if func
!
!-----------------------------------------------------------------------------
!      Volume 1: Complementary Error Function, y = erfc( x )
!
       if( func == 2_ik ) then                       ! 2 : erfc(x)
           call Out1( func, w(alg) )                 ! headlines
           do k = 1_ik, maxerfc, 1_ik                ! do... data points
              call DatError( func, k, x, taberf )    ! get taberf=erfc(x)
              do i = 1_ik, m-1_ik, 1_ik              ! do... algorithm
                 if( i /= alg ) cycle                ! not alg => cycle
                 it = 0_ik                           ! zero iterations
                 select case( i )
                  case(  1 ); f = erfcIntrinsic   ( x     )  ! High
                  case(  2 ); f = erfcCody        ( x     )  ! High
                  case(  3 ); f = erfcSchonfelder ( x     )  ! High
                  case(  4 ); f = erfcShepherd    ( x     )  ! High
                  case(  5 ); f = erfcSlatec      ( x     )  ! High
                  case(  6 ); f = erfcSun         ( x     )  ! High
                  case(  7 ); f = erfcOoura8a     ( x     )  ! High
                  case(  8 ); f = erfcOoura8b     ( x     )  ! High
                  case(  9 ); f = erfcOoura16     ( x     )  ! High
                  case( 10 ); f = erfcDia         ( x     )  ! High
                  case( 11 ); f = erfcSE          ( x, it )  ! SE
                  case( 12 ); f = erfcSEasymp     ( x, it )  ! SE asymp.
                  case( 13 ); f = erfcCF          ( x, it )  ! CF
                  case default; write(*,'("Algorithm not found")')
                 end select
                 call Out2( k, x, taberf, f, it )    ! output data result
              end do                                 ! end do i
              if( k == maxrow ) then                 ! max. number lines
                  call ScrBreak( "S" )               ! new page
                  call Out1( func, w(alg) )          ! new headlines
              end if
           end do                                    ! end do k
           call ScrBreak( "S" )                      ! (S)hort line, continue
       end if                                        ! end if func
!
!-----------------------------------------------------------------------------
!      Volume 1: Scaled Complementary Error Function, y = erfcx( x )
!
       if( func == 3_ik ) then                       ! 3 : erfcx(x)
           call Out1( func, w(alg) )                 ! headlines
           do k = 1_ik, maxerfcx, 1_ik               ! do... data points
              call DatError( func, k, x, taberf )    ! get taberf=erfcx(x)
              do i = 1_ik, m-1_ik, 1_ik              ! do... algorithm
                 if( i /= alg ) cycle                ! not alg => cycle
                 it = 0_ik                           ! zero iterations
                 select case( i )
                  case(  1 ); f = erfcxIntrinsic  ( x     )  ! High
                  case(  2 ); f = erfcxCody       ( x     )  ! High
                  case(  3 ); f = erfcxSchonfelder( x     )  ! High
                  case(  4 ); f = erfcxShepherd   ( x     )  ! High
                  case(  5 ); f = erfcxSlatec     ( x     )  ! High
                  case(  6 ); f = erfcxOoura8a    ( x     )  ! High
                  case(  7 ); f = erfcxOoura8b    ( x     )  ! High
                  case(  8 ); f = erfcxOoura16    ( x     )  ! High
                  case(  9 ); f = erfcxJohnson    ( x     )  ! High
                  case( 10 ); f = erfcxZaghloul   ( x     )  ! High
                  case( 11 ); f = erfcxZaghloulopt( x     )  ! High
                  case( 12 ); f = erfcxTH         ( x     )  ! High
                  case( 13 ); f = erfcxRen        ( x     )  ! Low
                  case( 14 ); f = erfcxSE         ( x, it )  ! SE
                  case( 15 ); f = erfcxSEasymp    ( x, it )  ! SE asymp.
                  case( 16 ); f = erfcxCF         ( x, it )  ! CF
                  case default; write(*,'("Algorithm not found")')
                 end select
                 call Out2( k, x, taberf, f, it )    ! output data result
              end do                                 ! end do i
              if( k == maxrow ) then                 ! max. number lines
                  call ScrBreak( "L" )               ! new page
                  call Out1( func, w(alg) )          ! new headlines
              end if
           end do                                    ! end do k
           call ScrBreak( "L" )                      ! (L)ong line, continue
       end if                                        ! end if func
!
!-----------------------------------------------------------------------------
!      Volume 2: Inverse Error Function, x = erfinv( y )
!
       if( func == 4_ik ) then                       ! 4 : erfinv(y)
           call Out1( func, w(alg) )                 ! headlines
           do k = 1_ik, maxerfinv, 1_ik              ! do... data points
              call DatError( func, k, y, taberf )    ! get taberf=erfinv(y)
              do i = 1_ik, m-1_ik, 1_ik              ! do... algorithm
                 if( i /= alg ) cycle                ! not alg => cycle
                 it = 0_ik                           ! zero iterations
                 f  = 0.00E+00_rk                    ! only in Volume I
                 call Out2(k, y, taberf, f, it)      ! output data result
              end do                                 ! end do i
              if( k == maxrow ) then                 ! max. number lines
                  call ScrBreak( "L" )               ! new page
                  call Out1( func, w(alg) )          ! new headlines
              end if
           end do                                    ! end do k
           call ScrBreak( "L" )                      ! (L)ong line, continue
       end if                                        ! end if func
!
!-----------------------------------------------------------------------------
!      Volume 2: Inverse Complementary Error Function, x = erfcinv( y )
!
       if( func == 5_ik ) then                       ! 5 : erfcinv(y)
           call Out1( func, w(alg) )                 ! headlines
           do k = 1_ik, maxerfcinv, 1_ik             ! do... data points
              call DatError( func, k, y, taberf )    ! get taberf=erfcinv(y)
              do i = 1_ik, m-1_ik, 1_ik              ! do... algorithm
                 if( i /= alg ) cycle                ! not alg => cycle
                 it = 0_ik                           ! zero iterations
                 f  = 0.00E+00_rk                    ! only in Volume I
                 call Out2(k, y, taberf, f, it)      ! output data result
              end do                                 ! end do i
              if( k == maxrow ) then                 ! max. number lines
                  call ScrBreak( "L" )               ! new page
                  call Out1( func, w(alg) )          ! new headlines
              end if
           end do                                    ! end do k
           call ScrBreak( "L" )                      ! (L)ong line, continue
       end if                                        ! end if func
!
!-----------------------------------------------------------------------------
!      Volume 2: Scaled Inverse Complementary Error Function, x = erfcxinv(y)
!
       if( func == 6_ik ) then                       ! 6 : erfcxinv(y)
           call Out1( func, w(alg) )                 ! headlines
           do k = 1_ik, maxerfcxinv, 1_ik            ! do... data points
              call DatError( func, k, y, taberf )    ! get taberf=erfcxinv(y)
              do i = 1_ik, m-1_ik, 1_ik              ! do... algorithm
                 if( i /= alg ) cycle                ! not alg => cycle
                 it = 0_ik                           ! zero iterations
                 f  = 0.00E+00_rk                    ! only in Volume I
                 call Out2(k, y, taberf, f, it)      ! output data result
              end do                                 ! end do i
              if( k == maxrow ) then                 ! max. number lines
                  call ScrBreak( "L" )               ! new page
                  call Out1( func, w(alg) )          ! new headlines
              end if
           end do                                    ! end do k
           call ScrBreak( "L" )                      ! (L)ong line, continue
       end if                                        ! end if func
!
!-----------------------------------------------------------------------------
!      "exit" selected
!
       if( func == 7_ik ) then                       ! 7 : exit
           ok = .true.                               ! exit for do while
       end if                                        ! end if func
!
    end do                                           ! do while .not. ok
!
!-----------------------------------------------------------------------------
!
    end program TestErf
!