!
!   kinds
!    Definition for the data types for GFortran
!   Reference:
!    GFortran (GNU Fortran) version 6.3.0-1, part of GCC (GNU Compiler
!    Collection). http://gcc.gnu.org/ or https://gcc.gnu.org/onlinedocs/
!    gcc-4.8.5/gfortran/About-GNU-Fortran.html#About-GNU-Fortran
!   Remarks:
!    Changing one of the default precision requires a recompilation of
!    the complete program, including all linked routines.
!   Implementation, adjustments and/or extensions by Thomas Hoering,
!     last modification: 31. January 2025
!
    module kinds
!
!-----------------------------------------------------------------------------
!
!   ISO Environment (do not reduce elements of the environment)
!
    use ISO_FORTRAN_ENV, only: INT8, INT16, INT32,  INT64,          &
                                            REAL32, REAL64, REAL128
!
!-----------------------------------------------------------------------------
!
    implicit none
!
!-----------------------------------------------------------------------------
!
!   COMPILER definition:
!
!   [do not change this parameter. In case you want to use Silverfrost ftn95,
!    use the file "201-def-kinds-Silverfrost.f95"                            ]
!
    integer, parameter       :: compiler  =  1        ! 1 := GFortran
!                                                       2 := Silverfrost
!
!-----------------------------------------------------------------------------
!
!   INTEGER definition:
!
!   Select one of the integer kinds: iki = 1, 2, 3 or 4;
!   preselection: kind=3 = INT32. No necessity to change the selection.
!
!   kind ISO   digits radix range bit byte Huge                former design.
!     1  INT8    7      2     2    8   1   127                 integer*1
!     2  INT16  15      2     4   16   2   32767               integer*2
!     3  INT32  31      2     9   32   4   2147483647          integer*4
!     4  INT64  63      2    18   64   8   9223372036854775807 integer*8
!
    integer, parameter       :: iki       =  3   ! kind=3 = INT32
!
    integer, parameter       :: ikx(1:4)  = (/ INT8, INT16, INT32, INT64 /)
!
    integer, parameter       :: ik        = ikx( iki )
!
!-----------------------------------------------------------------------------
!
!   REAL definition:
!
!   Select one of the real kinds: rki = 1, 2 or 3;
!   preselection: kind=2 = REAL64. Change the preselection in line 88.
!
!   kind kind ISO     storage digits precision range byte other designation
!     1   sp  REAL32    32      24      6        37    4  real*4
!     2   dp  REAL64    64      53     15       307    8  real*8/double prec.
!    n.a. ep  n.a.      80      64     18      4931   10  new, extended prec.
!     3   qp  REAL128  128     113     33      4931   16  quadruple precision
!
!   special values
!   kind kind ISO     Tiny               Huge                minexp  maxexp
!     1   sp  REAL32  1.1754943...E-0038 3.4028234...E+0038    -125     128
!     2   dp  REAL64  2.2250738...E-0308 1.7976931...E+0308   -1021    1024
!    n.a. ep  n.a.    3.3621031...E-4932 1.1897314...E+4932  -16381   16384
!     3   qp  REAL128 3.3621031...E-4932 1.1897314...E+4932  -16381   16384
!
!   kind kind ISO     Epsilon                 √(Epsilon)
!     1   sp  REAL32  2^-023=1.1920928...E-07 √(2^-023)=     =3.4526697...E-04
!     2   dp  REAL64  2^-052=2.2204460...E-16 √(2^-052)=2^-26=1.4901161...E-08
!    n.a. ep  n.a.    2^-063=1.0842021...E-19 √(2^-063)=     =3.2927225...E-10
!     3   qp  REAL128 2^-112=1.9259299...E-34 √(2^-112)=2^-56=1.3877787...E-17
!
!   kind kind ISO     SPACING             RRSPACING
!     1   sp  REAL32  1.1920928...E-0007  8.3886080...E+0006
!     2   dp  REAL64  2.2204460...E-0016  4.5035996...E+0015
!    n.a. ep  n.a.    1.0842021...E-0019  9.2233720...E+0018
!     3   qp  REAL128 1.9259299...E-0034  5.1922968...E+0033
!
    integer(ik), parameter   :: rki       =  3   ! kind=3 = REAL128
!
    integer(ik), parameter   :: rkx(1:3)  = (/ REAL32, REAL64, REAL128 /)
!
    integer(ik), parameter   :: rk        = rkx( rki )
!
!
!   REAL VALUES definitions from Fortran 2008 (ISO_FORTRAN_ENV)
!
!   sp2008   =  4,   Fortran 2008 value for REAL32,   sp, Single Precision
!   dp2008   =  8,   Fortran 2008 value for REAL64,   dp, Double Precision
!   qp2008   = 16,   Fortran 2008 value for REAL128,  qp, Quadruple Precision
!   rk2008   = cv2008(rki) allocates real value from current Fortran 2008
!
    integer(ik), parameter   :: sp2008    =  4_ik
    integer(ik), parameter   :: dp2008    =  8_ik
    integer(ik), parameter   :: qp2008    = 16_ik
    integer(ik), parameter   :: cv2008(3) = (/ sp2008, dp2008, qp2008 /)
    integer(ik), parameter   :: rk2008    = cv2008( rki )  ! rk = 1, 2 or 3
!
!-----------------------------------------------------------------------------
!
!   LOGICAL definition:
!
!   Select one of the logical kinds: 1, 2 or 3;
!   preselection: kind=3 = 4 bytes. No necessity to change the selection
!
!   kind   bit   byte   former designation
!     1     8     1     logical*1
!     2    16     2     logical*2
!     3    32     4     logical*4
!
    integer(ik), parameter   :: lki       =  3   ! kind=3 = 4 bytes selected
!
    integer(ik), parameter   :: lkx(1:3)  = (/ 1_ik, 2_ik, 4_ik /)
!
    integer(ik), parameter   :: lk        = lkx( lki )
!
!-----------------------------------------------------------------------------
!
    end module kinds
!
!-----------------------------------------------------------------------------
!