!
!   modules
!     Definition for the modules, except "kinds" and "constants"
!   Remarks:
!     Modules contains the following modules:
!     Volume 1 and Volume 2
!     1. mdef      error function tables, list of algorithms, screen menu and
!                  screen in-/output, Volume 2 only: Normal Distribution
!     Volume 1 only
!     2.mErf                                    error function y = erf     (x)
!     3.mErfc                    commplementary error function y = erfc    (x)
!     4.mErfcx            scaled commplementary error function y = erfcx   (x)
!     Volume 2 only
!     5.mErfinv   inverse                       error function x = erfinv  (y)
!     6.mErfcinv  inverse        commplementary error function x = erfcinv (y)
!     7.mErfcxinv inverse scaled commplementary error function x = erfcxinv(y)
!   Implementation, adjustments and/or extensions by Thomas Hoering,
!     last modification: 31. January 2025
!
!-----------------------------------------------------------------------------
!   Volume 1 and 2: Definitions/Menu
!
    MODULE mdef
      contains
      include "0204-def-Erf-Tables.f95"          ! tabulated error function
      include "0205-def-Menu.f95"                ! screen menu, in-/output
!     include "0206-def-NormalVt.f95"            ! Vol. 2: normal distribution
    end MODULE mdef
!
!-----------------------------------------------------------------------------
!   Volume 1: error function y = erf(x)
!
    MODULE mErf
      contains
      include '2100-Erf-High.f95'                ! high precision algorithm
      include '2200-Erf-Low.f95'                 ! low  precision algorithm
      include '2300-Erf-SE.f95'                  ! series expansion
      include '2400-Erf-CF.f95'                  ! continued fraction
    end MODULE mErf
!
!-----------------------------------------------------------------------------
!   Volume 1: complementary error function y = erfc(x)
!
    MODULE mErfc
      contains
      include '3100-Erfc-High.f95'               ! high precision algorithm
      include '3300-Erfc-SE.f95'                 ! series expansion
      include '3400-Erfc-CF.f95'                 ! continued fraction
    end MODULE mErfc
!
!-----------------------------------------------------------------------------
!   Volume 1: scaled complementary error function y = erfcx(x)
!
    MODULE mErfcx
      contains
      include '4100-Erfcx-High.f95'              ! high precision algorithm
!              4100-Erfcx-High-include.f95       ! required local include
      include '4200-Erfcx-Low.f95'               ! low  precision algorithm
      include '4300-Erfcx-SE.f95'                ! series expansion
      include '4400-Erfcx-CF.f95'                ! continued fraction
    end MODULE mErfcx
!
!-----------------------------------------------------------------------------
!   Volume 2: inverse error function x = erfinv(y)
!
!   MODULE mErfinv
!     contains
!     include '5100-Erfinv-High.f95'             ! high precision algorithm
!     include '5100-Erfinv-HighR.f95'            ! high precision root finding
!     include '5200-Erfinv-Low.f95'              ! low  precision algorithm
!     include '5300-Erfinv-SE.f95'               ! series expansion
!   end MODULE mErfinv
!
!-----------------------------------------------------------------------------
!   Volume 2: inverse complementary error function x = erfcinv(y)
!
!   MODULE mErfcinv
!     contains
!     include '6100-Erfcinv-High.f95'            ! high precision algorithm
!     include '6100-Erfcinv-HighR.f95'           ! high precision root finding
!     include '6200-Erfcinv-Low.f95'             ! low  precision algorithm
!     include '6300-Erfcinv-SE.f95'              ! series expansion
!   end MODULE mErfcinv
!
!-----------------------------------------------------------------------------
!   Volume 2: inverse scaled commplementary error function x = erfcxinv(y)
!
!   MODULE mErfcxinv
!     contains
!     include '7100-Erfcxinv-High.f95'           ! high precision algorithm
!     include '7100-Erfcxinv-HighR.f95'          ! high precision root finding
!     include '7200-Erfcxinv-Low.f95'            ! low  precision algorithm
!   end MODULE mErfcxinv
!
!-----------------------------------------------------------------------------
!