!
!-----------------------------------------------------------------------------------------------------
!
!   Include file "erfcx-High-include"
!     Scaled Complementary Error Function f = erfcx(x) with various
!     algorithms/calculations referenced Zaghloul (2024),
!     here: Chebyshev Polynomials parameter as an include file
!   Reference:
!     Mofreh R. Zaghloul, "Efficient multiple-precision computation
!      of the scaled complementary error function and the Dawson
!      integral", Numerical Algorithms, 2024, Volume 95, Issue 3,
!      Pages 1291–1308, https://doi.org/10.1007/s11075-023-01608-8
!   Remark:
!     Source, Copyright and Approval
!      See main file with the function "erfcxZaghloul"
!     Chebyshev parameters are grouped in cff
!      kind = 1 (sp)   : cff( 1481 : 1580 ), initiated c1
!      kind = 2 (dp)   : cff( 1301 : 1480 ), initiated b1
!      kind = 3 (ep/qp): cff(    1 : 1300 ), initiated a1 through a7
!     Chebyshev Polynomials
!      according Zaghloul (2024), page 1294ff, with
!      Real*16 of degree 12, c=2.1, t divided into 100 divisions
!      Real*8             8, c=2.1                  25
!      Real*4             4, c=2.1                  25
!     Maximum continuation lines
!      for Silverfrost FTN95 the maximum number of continuation 
!      lines = 99 lines, therefore a splitt into 9 parameter 
!      statements
!   Implementation, adjustments and/or extensions by Thomas Hoering,
!     last modification: 31. January 2025
!
!-----------------------------------------------------------------------------------------------------
!
!   parameter 1 to 1300 for kind=3 (ep) coefficients in a1 through a7
!
    real   (rk), parameter      :: a1(1_ik : 198_ik ) =              (/ &   ! 99 rows / 198 parameters
     0.1136788658764034508854522761732824735E-01_rk,  0.4547646634719256123865870383717325384E-01_rk,&
     0.2611383936621781724799464906913344225E-01_rk, -0.1877663271297551076178365411895962625E-01_rk,&
    -0.4949785469601751988351126254786530545E-01_rk, -0.3870861039461648302749853557590432381E-01_rk,&
     0.1586018712238603437898459841199328495E-01_rk,  0.9625935884345519493891984841041526764E-01_rk,&
     0.1772801736447436319485419006883871938E+00_rk,  0.2382011955157895564218964491009613088E+00_rk,&
     0.2686617064513125175943117157795778274E+00_rk,  0.2686617064513125175943235623901195844E+00_rk,&
    -0.7635785023891990551490185341603738563E-29_rk,  0.6437724379393033412824940922666464219E-02_rk,&
     0.4614360440808779389707969956349092311E-01_rk,  0.2607115562376607128716046539143462955E-01_rk,&
    -0.1877493207421508333998834137102914080E-01_rk, -0.4949790148453492704203576619788207503E-01_rk,&
    -0.3870860946222648604113131265421100746E-01_rk,  0.1586018710864021857845344283944758290E-01_rk,&
     0.9625935884360574157043546215228669298E-01_rk,  0.1772801736447424196703285789943871721E+00_rk,&
     0.2382011955157895634056073885620574226E+00_rk,  0.2686617064513125175670410622093709984E+00_rk,&
     0.2686617064513125175943882778998015692E+00_rk, -0.7050674181347162461715874458825882899E-25_rk,&
    -0.1073677391169710586404727928382735171E-02_rk,  0.4795675335738769173527850743234768731E-01_rk,&
     0.2586695064842249214277058568252860163E-01_rk, -0.1876075803164220723608408854724262764E-01_rk,&
    -0.4949857586036771761478993068903154031E-01_rk, -0.3870858632880974644427982596240156418E-01_rk,&
     0.1586018652293175367837290149152076378E-01_rk,  0.9625935885461619492602368510097543349E-01_rk,&
     0.1772801736445901290182475544044511795E+00_rk,  0.2382011955157910727887053863732473146E+00_rk,&
     0.2686617064513125074040361412244396743E+00_rk,  0.2686617064513125176360842820923988764E+00_rk,&
    -0.7882721769955195376448150636332074555E-22_rk, -0.9575187509913952434572845633395784624E-02_rk,&
     0.5102651767365299039400553058898479280E-01_rk,  0.2535482941751170316691399433336269955E-01_rk,&
    -0.1870857402712927448993570404528713568E-01_rk, -0.4950219207277951167892790552438619944E-01_rk,&
    -0.3870840685804958140218220385750104469E-01_rk,  0.1586017998468567731872846780012676779E-01_rk,&
     0.9625935903070687247120942318215023404E-01_rk,  0.1772801736411121141575814163474369219E+00_rk,&
     0.2382011955158401802211554567627738821E+00_rk,  0.2686617064513120371382758404287780235E+00_rk,&
     0.2686617064513125203772331625404089995E+00_rk, -0.7430582567843114320478253176581162986E-20_rk,&
    -0.1891889421158306695282692493681055844E-01_rk,  0.5551896377779017997504140489411913208E-01_rk,&
     0.2436035556177697318521112103297100613E-01_rk, -0.1857455873315106736067611880104380602E-01_rk,&
    -0.4951443569998862563420929937567157356E-01_rk, -0.3870760805538091564617430845137939086E-01_rk,&
     0.1586014182828567111417485532218472564E-01_rk,  0.9625936037502082311872411948880652417E-01_rk,&
     0.1772801736064479464801457224815445501E+00_rk,  0.2382011955164780537010106766966934254E+00_rk,&
     0.2686617064513040876056900624401935499E+00_rk,  0.2686617064513125806090534517564566777E+00_rk,&
    -0.2172109188065833372373874010895099803E-18_rk, -0.2890039374121329171730266050186065942E-01_rk,&
     0.6151301846713991866678739782499404748E-01_rk,  0.2270577394991940988389775601395531880E-01_rk,&
    -0.1829695809274120364013650271089482675E-01_rk, -0.4954596304793098155985224170203410739E-01_rk,&
    -0.3870505476628260677477261934108200284E-01_rk,  0.1585999063934571935048673482489693548E-01_rk,&
     0.9625936696972890050860301489181115470E-01_rk,  0.1772801733961612192139534532762882389E+00_rk,&
     0.2382011955212582013729638501616127749E+00_rk,  0.2686617064512305669229297420469318873E+00_rk,&
     0.2686617064513132674974409857302388409E+00_rk, -0.3164974365495559888641387740349834676E-17_rk,&
    -0.3926088636960519984373572659798448410E-01_rk,  0.6897489649094290652691081770037497666E-01_rk,&
     0.2023760703547965492417980780863068288E-01_rk, -0.1780117867982962572884439350784482093E-01_rk,&
    -0.4961331798276333029264791365456543431E-01_rk, -0.3869853487826498410422813603958125497E-01_rk,&
     0.1585952955890401057186044679882647448E-01_rk,  0.9625939097149562790693197163432774016E-01_rk,&
     0.1772801724834308704390151015697434316E+00_rk,  0.2382011955459848808552851706901777428E+00_rk,&
     0.2686617064507776084155328828537260229E+00_rk,  0.2686617064513183049413242029097829180E+00_rk,&
    -0.2888450282676243550940922616350933476E-16_rk, -0.4969289042323362796808467260061633426E-01_rk,&
     0.7773682734660083138650687103529288666E-01_rk,  0.1685961621440567314128309441329533968E-01_rk,&
    -0.1701072665176067916937278906148643775E-01_rk, -0.4973835380876657661848107202935908560E-01_rk,&
    -0.3868444966719920158886138834543175072E-01_rk,  0.1585837092954422317147198065226515262E-01_rk,&
     0.9625946109268780066031970012671585085E-01_rk,  0.1772801693846667870814346566798878334E+00_rk,&
     0.2382011956434978107735256830175542762E+00_rk,  0.2686617064487035308728683004824121731E+00_rk,&
     0.2686617064513450766765361084388541663E+00_rk, -0.1874719197607191741947156323081685362E-15_rk,&
    -0.5984968740951613985534002428606670548E-01_rk,  0.8748279205009890036840135000087685260E-01_rk,&
     0.1256851706811790636348908600338289356E-01_rk, -0.1586436628697246371642464893705055481E-01_rk,&
    -0.4994530510887585287225168726964656384E-01_rk, -0.3865785220781860069560223910311058731E-01_rk,&
     0.1585587563056472494734533076187795059E-01_rk,  0.9625963327573171449032120631285133480E-01_rk,&
     0.1772801607118841689760769210339579999E+00_rk,  0.2382011959544769867115178118701100392E+00_rk,&
     0.2686617064411687890617854084313635464E+00_rk,  0.2686617064514558345109036126872355970E+00_rk,&
    -0.9344482920014408104833914048752563484E-15_rk, -0.6935831203869826289107011233248978327E-01_rk,&
     0.9774375202834993666423715821275154239E-01_rk,  0.7488908282336018456741107564332732615E-02_rk,&
    -0.1433898464375213056630205186542864987E-01_rk, -0.5025477564094206975379269917428706635E-01_rk,&
    -0.3861316485592388984805041880301502996E-01_rk,  0.1585116627380971859025822225119640482E-01_rk,&
     0.9625999822046158802815175579037356940E-01_rk,  0.1772801400724260768151714374132908472E+00_rk,&
     0.2382011967852495050981927157439859900E+00_rk,  0.2686617064185775145327421908232939269E+00_rk,&
     0.2686617064518284679346876496575239653E+00_rk, -0.3753906884067950247687590414669989109E-14_rk,&
    -0.7783557920515427510660528658463463511E-01_rk,  0.1079043097216244236147859907841989780E+00_rk,&
     0.1903218214938521079207959266037994567E-02_rk, -0.1247660516832043632373217222956355690E-01_rk,&
    -0.5067422425327187085095542448191881790E-01_rk, -0.3854593821715041586412784551288116601E-01_rk,&
     0.1584330407191311989674691415734378366E-01_rk,  0.9626067424923227858138004123442925764E-01_rk,&
     0.1772800976570981637812797621006329925E+00_rk,  0.2382011986790121859850377378957627201E+00_rk,&
     0.2686617063614642347894117032672955019E+00_rk,  0.2686617064528731084915472277775638740E+00_rk,&
    -0.1251739753463629559518292755299610874E-13_rk, -0.8490632911835166331590790848508159417E-01_rk,&
     0.1172219037515278617285770069815933444E+00_rk, -0.3727766219383087292950521510553548246E-02_rk,&
    -0.1041292755272664400635825405593664961E-01_rk, -0.5118503964311287361738696675428011192E-01_rk,&
    -0.3845597105409358753176933154372061372E-01_rk,  0.1583174319545005991551693127938614488E-01_rk,&
     0.9626176635061351587907135672303290034E-01_rk,  0.1772800223874423880506719170990654178E+00_rk,&
     0.2382012023702415859749783271407248248E+00_rk,  0.2686617062392051742311478522981320481E+00_rk,&
     0.2686617064553287248429036011305352327E+00_rk, -0.3513636863785065066342251248579968296E-13_rk,&
    -0.9022280765152977589769089982996618015E-01_rk,  0.1248585740149241201244304163481905917E+00_rk,&
    -0.8757942902466480844316430190839328781E-02_rk, -0.8403850034642013963231378735008329294E-02_rk,&
    -0.5172695612875694437801863929925709033E-01_rk, -0.3835197328760700793397841985404882643E-01_rk,&
     0.1581718321180815272990277669605875870E-01_rk,  0.9626326473187476978822417873231514607E-01_rk,&
     0.1772799098937170430927684248256321449E+00_rk,  0.2382012083790566388333934508220901876E+00_rk,&
     0.2686617060224499951960563610088755061E+00_rk,  0.2686617064600698518032261035016899070E+00_rk,&
    -0.8269062945509227187474126973117838023E-13_rk, -0.9348391513491399328762728861879762904E-01_rk,&
     0.1299241365559911523099954803982733838E+00_rk, -0.1236582319339629453754224784249893259E-01_rk,&
    -0.6845827066167409816466459586686958316E-02_rk, -0.5218129648290556617972948494824252263E-01_rk,&
    -0.3825771733896109352122266769548045092E-01_rk,  0.1580291905713898028222637872804909997E-01_rk,&
     0.9626485135248287126865169556203164048E-01_rk,  0.1772797811545947935566307395690411010E+00_rk,&
     0.2382012158104315144037019837048586794E+00_rk,  0.2686617057327721563351521821179328235E+00_rk,&
     0.2686617064669162319059004180976329440E+00_rk, -0.1568850962436574901189856367675827791E-12_rk,&
    -0.9445297944748907100134098375604381583E-01_rk,  0.1315284151494903923994076137846804579E+00_rk,&
    -0.1358329415973429244284302101686871854E-01_rk, -0.6285780441834679484585001119623620449E-02_rk,&
    -0.5235522255518167041003781431810774603E-01_rk, -0.3821930115107232699918749121643683825E-01_rk,&
     0.1579673088087791461639346936904270395E-01_rk,  0.9626558382261106523549368322889476580E-01_rk,&
     0.1772797179255327525152077976480833711E+00_rk,  0.2382012196924189575315963636792144830E+00_rk,&
     0.2686617055718674733588579481180080871E+00_rk,  0.2686617064709589453678458010389465024E+00_rk,&
    -0.2034471980253508671818796803898465702E-12_rk, -0.9297275302771224865674070987113109668E-01_rk,&
     0.1288391274606056420231208324475231549E+00_rk, -0.1134339214111186946901259673439905117E-01_rk/)
!
    real   (rk), parameter      :: a2(1_ik : 198_ik ) =              (/ &   ! 99 rows / 198 parameters
    -0.7416713465498501843248352645541258100E-02_rk, -0.5196970211855956075877124238718984886E-01_rk,&
    -0.3831277563653087022304683035195011026E-01_rk,  0.1581326046998841929930896542995365751E-01_rk,&
     0.9626343583029214358737445307488522436E-01_rk,  0.1772799215004344737608012297221166369E+00_rk,&
     0.2382012059695157834014133536278791733E+00_rk,  0.2686617061964115172449884239504727325E+00_rk,&
     0.2686617064537288982353237850896135123E+00_rk,  0.1446437444857736688116160230731694976E-13_rk,&
    -0.8897649890803923574501395359109759653E-01_rk,  0.1211412502255924557492313292671404105E+00_rk,&
    -0.4545276507114209894369082309169248369E-02_rk, -0.1105619728033662026313755909307406653E-01_rk,&
    -0.5065413875827757375731334511624845043E-01_rk, -0.3865102537026340723421296561502713387E-01_rk,&
     0.1587669204080978455000585828316395055E-01_rk,  0.9625469415641780405310112972094506287E-01_rk,&
     0.1772808001676420140933351903108069320E+00_rk,  0.2382011431485357608228531179295813670E+00_rk,&
     0.2686617092289119054278310126713641014E+00_rk,  0.2686617063649879163827916926611996379E+00_rk,&
     0.1204991260478950483561928912329562005E-11_rk, -0.8249430409103250255613702343693442154E-01_rk,&
     0.1078932928992218417991748806743261370E+00_rk,  0.7867382557791566054042201253613686524E-02_rk,&
    -0.1810643987417634372384918079280728037E-01_rk, -0.4795046708856453999654883790718821719E-01_rk,&
    -0.3938850114338364550453739948776798925E-01_rk,  0.1602340698702827656980387397209598145E-01_rk,&
     0.9623324486933851547549991730822868482E-01_rk,  0.1772830872568866294670502759901915428E+00_rk,&
     0.2382009696901951890907424994830849898E+00_rk,  0.2686617181109940250188427467645502472E+00_rk,&
     0.2686617060892772693094352169901340819E+00_rk,  0.5128513821416504864382391203860827129E-11_rk,&
    -0.7365411269369990016597729559775888109E-01_rk,  0.8877595091548196503122858490197262843E-01_rk,&
     0.2682010476307414390530696557124871586E-01_rk, -0.2949656048326326028457783888074919323E-01_rk,&
    -0.4332894376289030727251270830307845107E-01_rk, -0.4072225436640975125552531066514489472E-01_rk,&
     0.1630413667596361081966051291596063752E-01_rk,  0.9618982355145306873249142411086236792E-01_rk,&
     0.1772879854900640610640692006433183527E+00_rk,  0.2382005766762548090273662573366610563E+00_rk,&
     0.2686617394009305360882477013940629260E+00_rk,  0.2686617053901592420994695708908331242E+00_rk,&
     0.1565300835543376365622437891932113217E-10_rk, -0.6267737023697794183485811768304020928E-01_rk,&
     0.6372909320129810698720251681371036111E-01_rk,  0.5302012787256648709460664526330216654E-01_rk,&
    -0.4610975754317513367481080268846786763E-01_rk, -0.3621688366760693193730531406411298221E-01_rk,&
    -0.4288777221835816616199916596492704239E-01_rk,  0.1678502184509008193020948770857721259E-01_rk,&
     0.9611135174997211746451696674465390963E-01_rk,  0.1772973244517523987061535053583190678E+00_rk,&
     0.2381997861675639797474128160540716236E+00_rk,  0.2686617845765136247782309363589785992E+00_rk,&
     0.2686617038252041628519504829140215784E+00_rk,  0.4050527392249077500300777558317757698E-10_rk,&
    -0.4986957384055879019272824926152890778E-01_rk,  0.3297391530075022270112875704712267469E-01_rk,&
     0.8687509376390958668246602652934212141E-01_rk, -0.6870002317232765093381785400968776498E-01_rk,&
    -0.2604028357275459929991556255890821494E-01_rk, -0.4614839110719015778309205718545269322E-01_rk,&
     0.1754692979964610144650459272550131301E-01_rk,  0.9598052711340422183202503735132481150E-01_rk,&
     0.1773137069942823292069635530041090968E+00_rk,  0.2381983270568853879119709579131702264E+00_rk,&
     0.2686618723122224039692249312407367107E+00_rk,  0.2686617006273564806712467260977420775E+00_rk,&
     0.9393678862179182202925220181034633238E-10_rk, -0.3560639141530718753734087709210510423E-01_rk,&
    -0.2981735268468775646236645896016852955E-02_rk,  0.1284250842635181294002993663870387173E+00_rk,&
    -0.9780466859779434060827461571582657930E-01_rk, -0.1227678214618850418718646778746689047E-01_rk,&
    -0.5077757435632517918203426233516042979E-01_rk,  0.1868240552288415949065382347295952967E-01_rk,&
     0.9577586905712660235973848509373757310E-01_rk,  0.1773406085610773132797561009648672660E+00_rk,&
     0.2381958120769618088570609532677261167E+00_rk,  0.2686620310447024588824708247967503768E+00_rk,&
     0.2686616945546333178030871411865873432E+00_rk,  0.2004375533012084512781641426426837558E-09_rk,&
    -0.2031631250043647951810185500641319807E-01_rk, -0.4335550780721819620095276235833488382E-01_rk,&
     0.1772943357716833380121716764052164667E+00_rk, -0.1336599684071662371233138456822922319E+00_rk,&
     0.5483096723088812450882229442808711369E-02_rk, -0.5703404231435486667744284843749565448E-01_rk,&
     0.2028975489168979688035779269595495917E-01_rk,  0.9547243614627935513519064292751151776E-01_rk,&
     0.1773823826210804696515809895428394655E+00_rk,  0.2381917217990885322519501811524469898E+00_rk,&
     0.2686623014201301173734024711575958017E+00_rk,  0.2686616837213020806209190772061142922E+00_rk,&
     0.3994143468697663191528869910601521028E-09_rk, -0.4460999889251971276809896890830135219E-02_rk,&
    -0.8711944021376706109783133984947878188E-01_rk,  0.2326674681552358817582833021124017811E+00_rk,&
    -0.1761275617403258734368259466925580389E+00_rk,  0.2747079084999126937555412701823339155E-01_rk,&
    -0.6513057060393295163014302877584544661E-01_rk,  0.2246397934436838470041675423480358799E-01_rk,&
     0.9504341783089780342692466393589066380E-01_rk,  0.1774441179124021337728704353701201743E+00_rk,&
     0.2381854036781815807605422441564821350E+00_rk,  0.2686627379413038935473299370678144491E+00_rk,&
     0.2686616654403925793923193207598855448E+00_rk,  0.7503525351600524202898227962842549075E-09_rk,&
     0.1148538811315385438841806928977387489E-01_rk, -0.1330435915700008183989089861679822566E+00_rk,&
     0.2932931049263894578874818335519735297E+00_rk, -0.2246388090851411705935766841909766703E+00_rk,&
     0.5367597479599488131124329786617021830E-01_rk, -0.7519813179200720817091905782437152175E-01_rk,&
     0.2528458861476389064910698775426772501E-01_rk,  0.9446275675000975130492250674813715982E-01_rk,&
     0.1775312913073024127546201799113871708E+00_rk,  0.2381760960885344208282315986643908483E+00_rk,&
     0.2686634088273176085808621329591153995E+00_rk,  0.2686616361293903026476675363755397353E+00_rk,&
     0.1337366313234602817466658338141262642E-08_rk,  0.2705664087219874060134384714588717931E-01_rk,&
    -0.1797513654626343612436278868376282359E+00_rk,  0.3575155512745190936312979918371337745E+00_rk,&
    -0.2781631322614947845039340435421842564E+00_rk,  0.8379007472957199834661846923405135634E-01_rk,&
    -0.8724784243740910755578470883638908441E-01_rk,  0.2880068428199827223552485212113782206E-01_rk,&
     0.9370887774243460652820145314299782352E-01_rk,  0.1776491658039779287869549850553901443E+00_rk,&
     0.2381629884070235856425224624374651971E+00_rk,  0.2686643928066421308045805903419011171E+00_rk,&
     0.2686615913567886903386787367111875393E+00_rk,  0.2271201535684708186530918525131122762E-08_rk,&
     0.4181354272612540853881380838706701114E-01_rk, -0.2257827332886224211556400711900340914E+00_rk,&
     0.4233329646008087198582198826889426755E+00_rk, -0.3352045866656016336484938211988417107E+00_rk,&
     0.1171627427955411142721574539232594659E+00_rk, -0.1011337893595183442458658318726355467E+00_rk,&
     0.3301409333740858408424489100410153603E-01_rk,  0.9276949001816300100595819337916873137E-01_rk,&
     0.1778018976552552679303115123143020872E+00_rk,  0.2381453280922582232714514487102555080E+00_rk,&
     0.2686657713410331486095218051780191476E+00_rk,  0.2686615261340048651354204562744326835E+00_rk,&
     0.3685721023429095192594249134313774583E-08_rk,  0.5536054408998978811798344477656681273E-01_rk,&
    -0.2696611783998208349507627657199082875E+00_rk,  0.4884784176405452481828495759690881121E+00_rk,&
    -0.3938287193251766020724379674503620604E+00_rk,  0.1527763456074824229988457991936452406E+00_rk,&
    -0.1165201615593766029232756121298544721E+00_rk,  0.3786169278843741086498269051821642583E-01_rk,&
     0.9164729849314209608327211323739499300E-01_rk,  0.1779913401319597088468590090160820208E+00_rk,&
     0.2381225840064241729375650202081725994E+00_rk,  0.2686676146860098770403281981041977367E+00_rk,&
     0.2686614355807635737590760499031198587E+00_rk,  0.5724762030393739452379777713553969530E-08_rk,&
     0.6735931181111135924734735209220704293E-01_rk, -0.3099601510734331883748202167699543294E+00_rk,&
     0.5505185993224044622412278056573598498E+00_rk, -0.4517193829878497612453431947427324934E+00_rk,&
     0.1892423433257341387489444125910799046E+00_rk, -0.1328561519486327487733697114407425682E+00_rk,&
     0.4319835815781213049214825913535853037E-01_rk,  0.9036632185302568166334772077984081555E-01_rk,&
     0.1782155628193684002029913345485101677E+00_rk,  0.2380946717056337716918719888186371369E+00_rk,&
     0.2686699602956544281170501907343835035E+00_rk,  0.2686613161071200819831355885196216764E+00_rk,&
     0.8514157508132676520237164177844602379E-08_rk,  0.7753867902885419706150483441403022523E-01_rk,&
    -0.3453651205484825449237923639263052900E+00_rk,  0.6069637515447389809229398120683591021E+00_rk,&
    -0.5062628431132324958236169353174821598E+00_rk,  0.2248218616650110165793312240614284699E+00_rk,&
    -0.1493617964197378045974346345026462193E+00_rk,  0.4878215097880829814934550049410142657E-01_rk,&
     0.8897838372769730868793573836958939436E-01_rk,  0.1784671423451363623735473151317384999E+00_rk,&
     0.2380622410665435741408753590802309701E+00_rk,  0.2686727824257858454095190506558140395E+00_rk,&
     0.2686611672559885282647573143210878263E+00_rk,  0.1211286196663850326412785770428833638E-07_rk,&
     0.8570078374686302955844593617660529049E-01_rk, -0.3747278755457376528432169536242912207E+00_rk,&
     0.6553818668396395024511923076490427653E+00_rk, -0.5546544492722200751971377423904013794E+00_rk,&
     0.2574709463045484803913501171258265709E+00_rk, -0.1650273053032376508076468460047095111E+00_rk/)
!
    real   (rk), parameter      :: a3(1_ik : 198_ik ) =              (/ &   ! 99 rows / 198 parameters
     0.5426340443007343095303463508063843783E-01_rk,  0.8756923522864890402936214412268343566E-01_rk,&
     0.1787313196661385104343706527896126861E+00_rk,  0.2380270196475375612272381480644873805E+00_rk,&
     0.2686759524093974681395023538555448708E+00_rk,  0.2686609943307795296251682181538002291E+00_rk,&
     0.1643676652587753825450653880058574203E-07_rk,  0.9172343676093127902924373978894437469E-01_rk,&
    -0.3971104826936609584139057493745001409E+00_rk,  0.6935101757642799157775645566175927209E+00_rk,&
    -0.5940215204690432707228891166701906424E+00_rk,  0.2849091140573575224197333168483002099E+00_rk,&
    -0.1786275670808186572909038300729033532E+00_rk,  0.5917925819140330369155563176098308931E-01_rk,&
     0.8626369637048181930013821457820352054E-01_rk,  0.1789841564250037226375809013712603520E+00_rk,&
     0.2379921970742941260695018765891068527E+00_rk,  0.2686791899711322016085209745673097797E+00_rk,&
     0.2686608118890854153554934090508785380E+00_rk,  0.2114919057222421242384750803193612439E-07_rk,&
     0.9555897663166539195978760972518965174E-01_rk, -0.4118171794709396328108439803787020665E+00_rk,&
     0.7193574820296994593136613703463361849E+00_rk, -0.6215550330539560225503409276615083408E+00_rk,&
     0.3047080522510295635097610358058246844E+00_rk, -0.1887524466969160066845050453415233297E+00_rk,&
     0.6295493586655994265402272630673663519E-01_rk,  0.8522918162152757800864812453358164640E-01_rk,&
     0.1791908541120211248730089905924339965E+00_rk,  0.2379628271792219076204069848874681857E+00_rk,&
     0.2686820070782517664747651233746890930E+00_rk,  0.2686606481128715216769364061659858231E+00_rk,&
     0.2551344644947897588620794805235692354E-07_rk,  0.9723004076904430565626140979947866943E-01_rk,&
    -0.4184133728991483133960860710091764046E+00_rk,  0.7312918635514193730589888522100899867E+00_rk,&
    -0.6346422539555701783314215295198415243E+00_rk,  0.3143958205162565261777718893638208984E+00_rk,&
    -0.1938523580702436746933148302278783643E+00_rk,  0.6491266916959612261870570620964270875E-01_rk,&
     0.8467700737839354654062681827237858540E-01_rk,  0.1793044207975034761364581796859003011E+00_rk,&
     0.2379462164502934203950368250294090853E+00_rk,  0.2686836471232255475631679949684407415E+00_rk,&
     0.2686605499686995022702222299836815622E+00_rk,  0.2820547977955862037509239953219708153E-07_rk,&
     0.9682280177016966519967373501669900659E-01_rk, -0.4167317650164069744856978301064340244E+00_rk,&
     0.7281095272946522636709806975427667274E+00_rk, -0.6309926224943190670777170788815763704E+00_rk,&
     0.3115707955278235281127086840898699754E+00_rk, -0.1922974648172223331901559174306197972E+00_rk,&
     0.6428868416377920078135988339894901170E-01_rk,  0.8486096743948866327695585585785755310E-01_rk,&
     0.1792648777602597599338875070059938983E+00_rk,  0.2379522604593193103900694802477996957E+00_rk,&
     0.2686830235952767309769584295163643751E+00_rk,  0.2686605889517278239334038071024790051E+00_rk,&
     0.2708848738186883683091690156508294768E-07_rk,  0.9447828639915241586696871013880116501E-01_rk,&
    -0.4068663735775174853553765642801219881E+00_rk,  0.7090820520787368779789295994631852562E+00_rk,&
    -0.6087498888256688755585336178073410754E+00_rk,  0.2940189429246797958517195893031726527E+00_rk,&
    -0.1824478512279023085196321454701651544E+00_rk,  0.6025811735696235785218678954308499005E-01_rk,&
     0.8607280190032731900651790287922772210E-01_rk,  0.1789991903173873787724702368473368518E+00_rk,&
     0.2379936852095276206467096326193890125E+00_rk,  0.2686786636991952121093300834319810659E+00_rk,&
     0.2686608670715559704089430811986153156E+00_rk,  0.1895657577872332047418885437363308379E-07_rk,&
     0.9038241468078325541020546096700575330E-01_rk, -0.3891558213396231069206968014750443484E+00_rk,&
     0.6739807463691382614753025211202112048E+00_rk, -0.5665846630735283553563076362479815911E+00_rk,&
     0.2598278283486810999015936782533880786E+00_rk, -0.1627311883551713135325337135205961782E+00_rk,&
     0.5196716939808959389814436285323844590E-01_rk,  0.8863436563081233711444944699374400480E-01_rk,&
     0.1784220828662975247918806037972063319E+00_rk,  0.2380861485010071482170504568159968293E+00_rk,&
     0.2686686634820852787876695018374650024E+00_rk,  0.2686615225963965133408938645513092124E+00_rk,&
    -0.7392348214437085087896246492775721723E-09_rk,  0.8475537520582496688490229810294773481E-01_rk,&
    -0.3641577074966465081584488046001050737E+00_rk,  0.6230782718684663991297670733604762783E+00_rk,&
    -0.5037629878378722756617692059905357856E+00_rk,  0.2074910735329320181709937175265350949E+00_rk,&
    -0.1317238568271655522113642013409084097E+00_rk,  0.3857127744369654230436911142710066503E-01_rk,&
     0.9288651101879336469970434191067780143E-01_rk,  0.1774378584007636169979510606057156759E+00_rk,&
     0.2382481579758873265843022126950411339E+00_rk,  0.2686506617972760595343900462761144115E+00_rk,&
     0.2686627349369157524530665073897718315E+00_rk, -0.3816236977528962596282464767854010893E-07_rk,&
     0.7784089849118124189282820716032684926E-01_rk, -0.3326161446658499087236363708762049196E+00_rk,&
     0.5571289451406323706407301954922087422E+00_rk, -0.4201881791871062916643554688631249025E+00_rk,&
     0.1359976682594635008168422146902369900E+00_rk, -0.8823121210133763397292319888692196269E-01_rk,&
     0.1927763542898923808313268000319853737E-01_rk,  0.9917491990097665538290460359993971559E-01_rk,&
     0.1759432898141191611088692864503671100E+00_rk,  0.2385007677098979757586538051475998894E+00_rk,&
     0.2686218407505318567361106844450737688E+00_rk,  0.2686647279360492316133483490037718763E+00_rk,&
    -0.1013318815258302400380304026319144479E-06_rk,  0.6989591245463815617275008438270935577E-01_rk,&
    -0.2954246525637991149489758877803992716E+00_rk,  0.4773301620031374708906601567958241356E+00_rk,&
    -0.3164148523137927972003711831335843878E+00_rk,  0.4490158140301960409775418906005451017E-01_rk,&
    -0.3136269645281251257345075917076856462E-01_rk, -0.6609952132698652333891678098013940996E-02_rk,&
     0.1078333346259309605001143745067290627E+00_rk,  0.1738315876212448195296539810667934232E+00_rk,&
     0.2388670239899120482977320506544788648E+00_rk,  0.2685789600472851690298659930907594703E+00_rk,&
     0.2686677707499335045455641287451819008E+00_rk, -0.2002989974490809751672292773258110366E-06_rk,&
     0.6118097196375428530562229035166891189E-01_rk, -0.2535865639398272953608047512785648195E+00_rk,&
     0.3852681541649855059481529161373592411E+00_rk, -0.1936356373581375951811508693159682721E+00_rk,&
    -0.6563162630066553223484311191934675800E-01_rk,  0.3940220213246053886897427622918006205E-01_rk,&
    -0.3964610969642247266933881318557464962E-01_rk,  0.1191648318160500417844229247307289377E+00_rk,&
     0.1709973806561683880330896295410406179E+00_rk,  0.2393711428758569584384766367719803736E+00_rk,&
     0.2685184318404893597840568899441437444E+00_rk,  0.2686721754703327191708027929110222762E+00_rk,&
    -0.3472186694355192848253823327612374678E-06_rk,  0.5195175638121191895235507411315022276E-01_rk,&
    -0.2081749452166338237835486542142892173E+00_rk,  0.2828517717347712949999724317854087258E+00_rk,&
    -0.5364250068223915706437928077030766556E-01_rk, -0.1948031054077100580367616830021852622E+00_rk,&
     0.1241606081311831215448239290257510971E+00_rk, -0.8020112059023650014325354896251354882E-01_rk,&
     0.1334219405568861210927647579024323032E+00_rk,  0.1673425776389554360283581063813238527E+00_rk,&
     0.2400374166300794384724720464470755832E+00_rk,  0.2684364412620589351361491514622645471E+00_rk,&
     0.2686782906606272354621254874977111125E+00_rk, -0.5562715494598817265797150551186904682E-06_rk,&
     0.4245183213995587430896231790359264338E-01_rk, -0.1602937929038617921674612208599610433E+00_rk,&
     0.1722381982425481293966029374332911903E+00_rk,  0.1012342537604689797721180952787977816E+00_rk,&
    -0.3411844577535334134640443666493321848E+00_rk,  0.2225482739252812295698756932419380123E+00_rk,&
    -0.1284225723938854327306226774205349185E+00_rk,  0.1507865185863507652123659292352341132E+00_rk,&
     0.1627829130968135423784855178431712732E+00_rk,  0.2408888622275113821267743141772272388E+00_rk,&
     0.2683291158494983746188867950006240479E+00_rk,  0.2686864900620765879958316822463774246E+00_rk,&
    -0.8433899525192459376998957852260608036E-06_rk,  0.3290678718794566863990385483472009651E-01_rk,&
    -0.1110419670491977480467397281035720199E+00_rk,  0.5575447360516690339687155607929183018E-01_rk,&
     0.2682053621209536433338596487671626291E+00_rk, -0.5027461124580437682928299249348637431E+00_rk,&
     0.3337188418743890478362013745804378150E+00_rk, -0.1842034397720909698531433094804915831E+00_rk,&
     0.1713503586110417366309781073184283224E+00_rk,  0.1572549254469286996122726778001246880E+00_rk,&
     0.2419456419102560925605307332521196497E+00_rk,  0.2681927446411020623782950108862994585E+00_rk,&
     0.2686971558768711830362655984141329163E+00_rk, -0.1225742404452664488173091612131307209E-05_rk,&
     0.2351976459276752611440487822119185639E-01_rk, -0.6148099283587094395550763375102016655E-01_rk,&
    -0.6418153599873517743812460338649316437E-01_rk,  0.4441158596162075047966146993397262213E+00_rk,&
    -0.6769083656315959763245734882115544958E+00_rk,  0.4563413282006209035347666901977041101E+00_rk,&
    -0.2471583117426889639558611514713616919E+00_rk,  0.1950974993301109227797236573605619473E+00_rk,&
     0.1507230718713119482425299244786218236E+00_rk,  0.2432233020345502042208953021939672218E+00_rk,&
     0.2680240449346423412954790364439748146E+00_rk,  0.2687106562469526303082197242198521862E+00_rk,&
    -0.1720935704234952684684864513664285519E-05_rk,  0.1446835612152390606310131739733581447E-01_rk,&
    -0.1260752553295715454836988585990729491E-01_rk, -0.1851374782314978971551472839586908525E+00_rk,&
     0.6255474680076243766740951293078433039E+00_rk, -0.8606121454606178284206533186822211228E+00_rk,&
     0.5886158877497300478873772145940793144E+00_rk, -0.3166090690728269891511035847844896073E+00_rk,&
     0.2218891633380024349059808287815566188E+00_rk,  0.1431866567420825693163701601124381104E+00_rk/)
!
    real   (rk), parameter      :: a4(1_ik : 198_ik ) =              (/ &   ! 99 rows / 198 parameters
     0.2447308912157927149597232073975128252E+00_rk,  0.2678204717414999829145570668438053460E+00_rk,&
     0.2687273168155330794102114687630834579E+00_rk, -0.2345901258856825305695999138323580136E-05_rk,&
     0.5902764303622319921819726840567778596E-02_rk,  0.3466904750647258098623431480122163917E-01_rk,&
    -0.3047374287256397051351524321530781310E+00_rk,  0.8089253799980195483551342106381999221E+00_rk,&
    -0.1050405838155848939676420944472788575E+01_rk,  0.7283070554525735054700889169599823315E+00_rk,&
    -0.3915808591294974660032843585569378599E+00_rk,  0.2514521416668484308359037265457589537E+00_rk,&
     0.1346862394760639165112252581977735153E+00_rk,  0.2464690310517913131013075480487262497E+00_rk,&
     0.2675805619939343872309681350742449788E+00_rk,  0.2687473865702111747333575769500877180E+00_rk,&
    -0.3115443750140762512160624193342616442E-05_rk, -0.2054896666700275608725555861924400244E-02_rk,&
     0.7954368599040164109608944781066758897E-01_rk, -0.4207252152758644448062772826782807675E+00_rk,&
     0.9906249667821541882478833049043733554E+00_rk, -0.1242544038063992069487551049197208837E+01_rk,&
     0.8727928951388273951921785240146866334E+00_rk, -0.4708087303847571157034746330866551419E+00_rk,&
     0.2833713001286732952773417089574714434E+00_rk,  0.1253091943271013603893496155340346855E+00_rk,&
     0.2484280217083273315522080131055355981E+00_rk,  0.2673043027556379329130276350870487314E+00_rk,&
     0.2687709985075409771006497572971383514E+00_rk, -0.4040444708247764776064818566207983591E-05_rk,&
    -0.9310315678447466081363889079125276676E-02_rk,  0.1213275270610214757708676704420496256E+00_rk,&
    -0.5310185829325849108415622293605905907E+00_rk,  0.1167074381745510414981788829666666745E+01_rk,&
    -0.1433093863417952997286845632999004317E+01_rk,  0.1019127852999238808069360658531455019E+01_rk,&
    -0.5527548060756259584839018065536784129E+00_rk,  0.3170867057681943583200720038593576457E+00_rk,&
     0.1151941181531429290949698276473924071E+00_rk,  0.2505860698147264279606933813857298257E+00_rk,&
     0.2669935102151755367777700380330213800E+00_rk,  0.2687981260112718885064115496287423377E+00_rk,&
    -0.5125730809989169560720764478860774981E-05_rk, -0.1579588257830651843372267490846493059E-01_rk,&
     0.1594547429976570409558549426975279909E+00_rk, -0.6337532128158795352580388809769513190E+00_rk,&
     0.1334849617650161196187444618879593569E+01_rk, -0.1618044489382255829400221404761667348E+01_rk,&
     0.1164116633102301650494501469660296613E+01_rk, -0.6356354224490297850981458698915564956E+00_rk,&
     0.3518956738294059490544290354718684918E+00_rk,  0.1045338210094358607896103583807188997E+00_rk,&
     0.2529077271160592407281560543157097628E+00_rk,  0.2666522042596750731625048035459697468E+00_rk,&
     0.2688285361812520540820802765531235174E+00_rk, -0.6367636001429402026695377296185097067E-05_rk,&
    -0.2146893956943861799142156832427513479E-01_rk,  0.1934848604734179208673218258769613067E+00_rk,&
    -0.7273161483858157948228491543673949886E+00_rk,  0.1490759245681067381954835180233217706E+01_rk,&
    -0.1793415762848664101760074255178954819E+01_rk,  0.1304396095831704683857413713298397977E+01_rk,&
    -0.7174572534530157277701028356995796757E+00_rk,  0.3869598282511986031752359011902719306E+00_rk,&
     0.9357668608571049095199838338914856178E-01_rk,  0.2553426250924674868501970884852281730E+00_rk,&
     0.2662869620551551945649501607108759790E+00_rk,  0.2688617416680121896384845008359916292E+00_rk,&
    -0.7751307008350175008858078791422413897E-05_rk, -0.2630955134905571978170431300165821863E-01_rk,&
     0.2231010869297957648237519888080740770E+00_rk, -0.8103686621839609116034058654170761738E+00_rk,&
     0.1631916775175620653322683848709601695E+01_rk, -0.1955362142168438018824313998165229316E+01_rk,&
     0.1436522026158297943714258202779764098E+01_rk, -0.7960611073549028892694782102969387979E+00_rk,&
     0.4213170630259531594102418902543506051E+00_rk,  0.8262624699182055703652266076269832249E-01_rk,&
     0.2578245834582622909027159919253607510E+00_rk,  0.2659072333879246784322631536380290095E+00_rk,&
     0.2688969528411858016176999881150716982E+00_rk, -0.9247822473686161470033960837896977201E-05_rk,&
    -0.3031794786889117266988206490114465459E-01_rk,  0.2481052576605802872750453864254399247E+00_rk,&
    -0.8818590004745004812189724645792326549E+00_rk,  0.1755799281324560256253130808070858573E+01_rk,&
    -0.2100268709229357388951601832820804432E+01_rk,  0.1557057617538509244031957448269925502E+01_rk,&
    -0.8691718227205217695968949931207056000E+00_rk,  0.4538980979272748995344022055127090280E+00_rk,&
     0.7203889830996559719843483798453066481E-01_rk,  0.2602711594853009222131721676929747801E+00_rk,&
     0.2655256005971194212802908752076574980E+00_rk,  0.2689330323321516657071639190492773201E+00_rk,&
    -0.1081121581722475136815269335390278384E-04_rk, -0.3351177796872512408106894018369531451E-01_rk,&
     0.2684100469929999296411937379487489972E+00_rk, -0.9410257661428261707068106389520593359E+00_rk,&
     0.1860291620477386345174660217962613609E+01_rk, -0.2224836589903018209498826098036400928E+01_rk,&
     0.1662660652163943641084725197699589639E+01_rk, -0.9344525171448102182944758180372345439E+00_rk,&
     0.4835471487531705230075649880942246693E+00_rk,  0.6221972615297951949117780020112641710E-01_rk,&
     0.2625836910286232892433405982530187846E+00_rk,  0.2651579667597888836687108577755524680E+00_rk,&
     0.2689684541295943906086924007934832377E+00_rk, -0.1237550991846109715287227787453117732E-04_rk,&
    -0.3592329384362651110489778023972014675E-01_rk,  0.2840290845492122082372284961966765134E+00_rk,&
    -0.9873929406404388841525115050786805395E+00_rk,  0.1943716162652835251974900689958877231E+01_rk,&
    -0.2326155752698958706280023622605654041E+01_rk,  0.1750166607561076972593670856523768380E+01_rk,&
    -0.9895613526857566885390440337834176053E+00_rk,  0.5090460860950588433604652233652403521E+00_rk,&
     0.5361651576676940012946701023788458816E-01_rk,  0.2646478696743387435376630119206830308E+00_rk,&
     0.2648236573461153548244478707641684175E+00_rk,  0.2690012694617405876254568942519399756E+00_rk,&
    -0.1385188690460693192632980174883288881E-04_rk, -0.3759656676703111707643730461146057789E-01_rk,&
     0.2950655893775969477185064173782043645E+00_rk, -0.1020757707156009137843970344145367765E+01_rk,&
     0.2004848500046380222111078193993808958E+01_rk, -0.2401763799081554167534890485779247264E+01_rk,&
     0.1816665258530647294643748039011878479E+01_rk, -0.1032208973324350816175429953721247089E+01_rk,&
     0.5291413424652073404826526767452095661E+00_rk,  0.4671205983316556642319240796026454769E-01_rk,&
     0.2663348623729402783028523418494361695E+00_rk,  0.2645454227771189744895985830358681870E+00_rk,&
     0.2690290816656081215230826236329651867E+00_rk, -0.1512612781841850168269459701037794564E-04_rk,&
    -0.3858481484976806241511061882195202255E-01_rk,  0.3017000871074410210651356121504646190E+00_rk,&
    -0.1041172326324539669517671479994690172E+01_rk,  0.2042920027695528850329897304838734453E+01_rk,&
    -0.2449689982070410353680279031139604733E+01_rk,  0.1859568746427945870393710367231304144E+01_rk,&
    -0.1060214834585312966273384903600684640E+01_rk,  0.5425727480908656117738761089154176614E+00_rk,&
     0.4201495132718857541112055624213509736E-01_rk,  0.2675029810945801882799318605167230050E+00_rk,&
     0.2643493320944666024593172085856380876E+00_rk,  0.2690490321207156212801520022987049797E+00_rk,&
    -0.1605646403526869851015238012458205984E-04_rk, -0.3894790475581707768124695965457714265E-01_rk,&
     0.3041777141494922051142184930138447477E+00_rk, -0.1048921341677092882168763480638611989E+01_rk,&
     0.2057608633469675787942063155008314125E+01_rk, -0.2468484268049270112532569142726790463E+01_rk,&
     0.1876669529622165001715566996369581345E+01_rk, -0.1071560773675461533154903677074746154E+01_rk,&
     0.5481034315755033797457086198245126056E+00_rk,  0.4004909633990031685349719315628650853E-01_rk,&
     0.2679998812654170059853472326116154217E+00_rk,  0.2642645511725020094449606619711801559E+00_rk,&
     0.2690577991154967181086943949220173477E+00_rk, -0.1647198447496969239407081605126092701E-04_rk,&
    -0.3875007186213023503425870496784805167E-01_rk,  0.3027955436581947895517516586367192784E+00_rk,&
    -0.1044495364968867958949073675433080881E+01_rk,  0.2049018980111085685383745315616344402E+01_rk,&
    -0.2457231771843885192515833963724280887E+01_rk,  0.1866187086193276441952534722413754779E+01_rk,&
    -0.1064440348345256395078726584479890688E+01_rk,  0.5445499119689679556782694263061249476E+00_rk,&
     0.4134222355380249920397559785893110909E-01_rk,  0.2676652517843010974203888190244371320E+00_rk,&
     0.2643230024313435052237311211990965647E+00_rk,  0.2690516112261336963551340036862790515E+00_rk,&
    -0.1617173960176360984198202532030587923E-04_rk, -0.3805788776884040197095523432910110191E-01_rk,&
     0.2978902950471636889013232712809845410E+00_rk, -0.1028562622243538964523520149325288420E+01_rk,&
     0.2017654017402770139128759006412799863E+01_rk, -0.2415553334724973305814728821543528124E+01_rk,&
     0.1826802691761685004558730057673600336E+01_rk, -0.1037302691478077399717801338561068001E+01_rk,&
     0.5308115311508913626454890059736960637E+00_rk,  0.4641369701042189168178672435881222863E-01_rk,&
     0.2663339429610167022649941634374376343E+00_rk,  0.2645589067036986779813302524700080556E+00_rk,&
     0.2690262764299814860478768504712015579E+00_rk, -0.1492467483793315280779526289681794922E-04_rk,&
    -0.3693849057922761221184489229771144482E-01_rk,  0.2898267160462517051456887598748463664E+00_rk,&
    -0.1001939340539725220201096056499949866E+01_rk,  0.1964379436097647541812623644393732103E+01_rk,&
    -0.2343593372152392949672331994460724358E+01_rk,  0.1757682024308088351178146303465256645E+01_rk,&
    -0.9888898733555907280028583403633792385E+00_rk,  0.5058984262345790769756203837244787446E+00_rk,&
     0.5576195698132711772057033871957275839E-01_rk,  0.2638394643358855996289101342609527408E+00_rk,&
     0.2650082116229342592149472913257528821E+00_rk,  0.2689772277622012700719224559664667873E+00_rk/)
!
    real   (rk), parameter      :: a5(1_ik : 198_ik ) =              (/ &   ! 99 rows / 198 parameters
    -0.1247051246547842523298000150958658927E-04_rk, -0.3545808206630182850893909642918974156E-01_rk,&
     0.2789868565282309028632251091292575969E+00_rk, -0.9655599323802122315888368573694582106E+00_rk,&
     0.1890382777553790294283403012847143257E+01_rk, -0.2241996390710628282479967592595538869E+01_rk,&
     0.1658485740023333530554262425605335143E+01_rk, -0.9182670223419531908049819026151749873E+00_rk,&
     0.4689573165313328530744909729234941528E+00_rk,  0.6985192022641426708683876132929331051E-01_rk,&
     0.2600177724845796403320460798725456045E+00_rk,  0.2657079144977420827147600973706692973E+00_rk,&
     0.2688995858696411455471824553297069541E+00_rk, -0.8521682697656020782905241390132510337E-05_rk,&
    -0.3368068669700498517013518283671590766E-01_rk,  0.2657603887671274132336877997036144649E+00_rk,&
    -0.9204477994454969288437703466606771557E+00_rk,  0.1797128855803704451350417211271746308E+01_rk,&
    -0.2111873763717727434427565317051070068E+01_rk,  0.1529368509372197808993770809490560635E+01_rk,&
    -0.8248447160959576315382179022042613863E+00_rk,  0.4192944735533102519727800949527421050E+00_rk,&
     0.8910266625354679864491585796089244655E-01_rk,  0.2547112598959034895882432134721982093E+00_rk,&
     0.2666952909928239594100584342202318906E+00_rk,  0.2687882383365782195742021049500194602E+00_rk,&
    -0.2766381896620594394453899045717585889E-05_rk, -0.3166716038059784125510688553926495950E-01_rk,&
     0.2505360708758750610440182238678795815E+00_rk, -0.8676874357380343737694000075186840752E+00_rk,&
     0.1686313044142750498500624040238842569E+01_rk, -0.1954762467519181966735648021704556457E+01_rk,&
     0.1370967293909736037508998654532917459E+01_rk, -0.7083934094606140551880378712368793898E+00_rk,&
     0.3563953504312572163269705880980797124E+00_rk,  0.1138757213328455046756209833032187717E+00_rk,&
     0.2477728500133049302988749552495905169E+00_rk,  0.2680070439348638889010110057707831023E+00_rk,&
     0.2686379351693165893907286551393850504E+00_rk,  0.5127190417545230222350974904411118911E-05_rk,&
    -0.2947443156928836096238958500510448461E-01_rk,  0.2336943997646811377680280567280381661E+00_rk,&
    -0.8083983703971184139170219230259775601E+00_rk,  0.1559813838092913865161913626750393120E+01_rk,&
    -0.1772577522949451826558138244343372798E+01_rk,  0.1184379878419397484020706855756932434E+01_rk,&
    -0.5690499036098012661410202489772411428E+00_rk,  0.2799404638733203166797549704177934713E+00_rk,&
     0.1444642282251104632702581988733882402E+00_rk,  0.2390701006026694272347250603311254676E+00_rk,&
     0.2696783891176331918989720774186915925E+00_rk,  0.2684433993472051260817055964914255732E+00_rk,&
     0.1550539326507806780509699994105547302E-04_rk, -0.2715495375398086078017019252217303771E-01_rk,&
     0.2156014574200045893025412345413664680E+00_rk, -0.7437113561162342547045087726125143803E+00_rk,&
     0.1419645941875002359405776763285173169E+01_rk, -0.1567559867870681541029735232218863971E+01_rk,&
     0.9711348489358934229797300318669999823E+00_rk, -0.4073160772945000437102548328572553130E+00_rk,&
     0.1898172425364883201407263008965826416E+00_rk,  0.1810832583317271797148806284593918952E+00_rk,&
     0.2284892176807998216625098148152165700E+00_rk,  0.2717420970199590903170881579710382358E+00_rk,&
     0.2681994508918853659433451734432380329E+00_rk,  0.2872251316743800105152899680942885770E-04_rk,&
    -0.2475634623539820824991200116367597401E-01_rk,  0.1966039195850467392163282672115370198E+00_rk,&
    -0.6747470845829628929046844262880667624E+00_rk,  0.1267914946306734619495135716293533072E+01_rk,&
    -0.1342221316970777634982766262147741172E+01_rk,  0.7331543268270099191378281781864908802E+00_rk,&
    -0.2240502903085832243301007586035760365E+00_rk,  0.8612767598849761223481452457609941412E-01_rk,&
     0.2238614858671892971208406685027348276E+00_rk,  0.2159388851386082778191875117381393947E+00_rk,&
     0.2742275108286085174525994532036132644E+00_rk,  0.2679011424885466020792042382599484477E+00_rk,&
     0.4513298094588278204936033463629786924E-04_rk, -0.2232119907663427006254611184772870411E-01_rk,&
     0.1770251686802164954359596279344689153E+00_rk, -0.6025975981023100755297031221057328177E+00_rk,&
     0.1106774481034239031950685313124747806E+01_rk, -0.1099288154296535800912817197715440021E+01_rk,&
     0.4727108358786261429607691108092237447E+00_rk, -0.2045202843572765872334276640714599478E-01_rk,&
    -0.3080828558461139696197866276207224734E-01_rk,  0.2728344023483235209591413853086995937E+00_rk,&
     0.2013538206623188868864003900688594807E+00_rk,  0.2771595620504489869729943238023667395E+00_rk,&
     0.2675439043248166534136765587634400645E+00_rk,  0.6508250895335259286609443419742409284E-04_rk,&
    -0.1988701813108014303957997549390452061E-01_rk,  0.1571624324727643466501735338092639766E+00_rk,&
    -0.5283104681706940746779704617652081905E+00_rk,  0.9383865404902674654973793652304060692E+00_rk,&
    -0.8416447622896554370817534453931909748E+00_rk,  0.1923796982102622378318662735410220566E+00_rk,&
     0.2019595134722532911312572808901140666E+00_rk, -0.1604535223879144264418395898206725003E+00_rk,&
     0.3279392058177380541944348600252421979E+00_rk,  0.1846979762699379763578936241336604119E+00_rk,&
     0.2805578053014703810782105900650292945E+00_rk,  0.2671236955046195213757542445600651258E+00_rk,&
     0.8889825241817186500800685089720089987E-04_rk, -0.1748628677887381171835435989213404858E-01_rk,&
     0.1372848558828086566810469435711751761E+00_rk, -0.4528757279825035797706226453206563262E+00_rk,&
     0.7648855068198220397795671624743088128E+00_rk, -0.5722785277912761908572517057560559977E+00_rk,&
    -0.1050116682353530670026498117006607957E+00_rk,  0.4413721182612883879505260535706398124E+00_rk,&
    -0.3020585700230990892070216996692631684E+00_rk,  0.3890114543225682090098202323224722843E+00_rk,&
     0.1659673113665001845881301446394031002E+00_rk,  0.2844354935908722958817677904747204978E+00_rk,&
     0.2666371591534539286694108613488134010E+00_rk,  0.1168781278392607319125910519274649021E-03_rk,&
    -0.1514662230541797134100924442646622515E-01_rk,  0.1176324046128533449832539001168492280E+00_rk,&
    -0.3772154767225325359652914647622361341E+00_rk,  0.5883462287166531137717130739211270177E+00_rk,&
    -0.2942270891500286945023718733453331767E+00_rk, -0.4164362364530206543663593284547855121E+00_rk,&
     0.6957116468132222578620184275595308280E+00_rk, -0.4546702357203791059745924195387191923E+00_rk,&
     0.4557835286736480791392814141636496765E+00_rk,  0.1451920772790984420384282325918307195E+00_rk,&
     0.2887987146101114784225335335974255675E+00_rk,  0.2660817781631719169994702162443510692E+00_rk,&
     0.1492794480101012332132284354383191463E-03_rk, -0.1289100655037154138359683619680500058E-01_rk,&
     0.9841549519546038166730891827523645208E-01_rk, -0.3021760185302205494876677921111528846E+00_rk,&
     0.4107563658952887649870028397009707816E+00_rk, -0.1052880675684203598385430188148558173E-01_rk,&
    -0.7387204145660444705915959422144546338E+00_rk,  0.9626766607424955970436170952375012195E+00_rk,&
    -0.6171436904057144089037091066883620979E+00_rk,  0.5278849066706190498579267355535021169E+00_rk,&
     0.1224385643492214953120913813522828496E+00_rk,  0.2936456072376441897465722447233869806E+00_rk,&
     0.2654560284310745476918353414288922273E+00_rk,  0.1863070565645727486922216858468488268E-03_rk,&
    -0.1073807240252937715218799158992816472E-01_rk,  0.7981524576563667909341953842839137491E-01_rk,&
    -0.2285223573151213773113035544263445085E+00_rk,  0.2339930768695079876595740073845512778E+00_rk,&
     0.2758228415313791875196036376724238484E+00_rk, -0.1068596530152236472045086684609217098E+01_rk,&
     0.1239775668064759977919159634530633978E+01_rk, -0.7881576627129641437531824182246329148E+00_rk,&
     0.6048442108628971118873647706341193300E+00_rk,  0.9781027542760954089410405060789198416E-01_rk,&
     0.2989656757395857720601703543120219658E+00_rk,  0.2647595264302344536394088151266381043E+00_rk,&
     0.2281011643542314185427411343007012942E-03_rk, -0.8702429796910886896558052199391307508E-02_rk,&
     0.6198424461739890534034914832323764532E-01_rk, -0.1569348389760298797418872712233458509E+00_rk,&
     0.5980401392250283134605811226676551323E-01_rk,  0.5619204132416139528413773184204116977E+00_rk,&
    -0.1402753762794484254201299008117796074E+01_rk,  0.1524366108001875541061425159225033854E+01_rk,&
    -0.9662323168328456348483792955882331560E+00_rk,  0.6860929553916726642406080592051545119E+00_rk,&
     0.7144850264557923927007781124975504361E-01_rk,  0.3047392170524915033122673281178636717E+00_rk,&
     0.2639931680034550416899075978110744624E+00_rk,  0.2747251050371030586951768548914612762E-03_rk,&
    -0.6795016989703705568680505449037946735E-02_rk,  0.4504773869487401112950096464903481297E-01_rk,&
    -0.8800771367305353465938324834209929282E-01_rk, -0.1102075060840576019545378780582098607E+00_rk,&
     0.8449788397950463317396153232367678830E+00_rk, -0.1737886668363953462633295342715793228E+01_rk,&
     0.1813694226998590060407479991806006482E+01_rk, -0.1149749365850597996229202383633930183E+01_rk,&
     0.7709708851868623286908926695723964857E+00_rk,  0.4353229726506502015551152160987913470E-01_rk,&
     0.3109368741501342052395875955638782530E+00_rk,  0.2631592553982833426088334455120708125E+00_rk,&
     0.3261532376726589938960733352227291522E-03_rk, -0.5023464969822423053422619482412865511E-02_rk,&
     0.2910515096718957735819508637692312209E-01_rk, -0.2224938118157937256949399311765866440E-01_rk,&
    -0.2745933634907940123044890110760788340E+00_rk,  0.1122366738785079450753334933945137130E+01_rk,&
    -0.2070740578775026048401541614833448329E+01_rk,  0.2104935050782432511237666459158038512E+01_rk,&
    -0.1336973955273362043056786044048720659E+01_rk,  0.8587327732384321708774452296080101036E+00_rk,&
     0.1427783491298470415495955682559578311E-01_rk,  0.3175193258972265631259349771745059813E+00_rk,&
     0.2622616097494340855890018784911635476E+00_rk,  0.3822592297034987461194576797528284615E-03_rk,&
    -0.3392464856663918348218814024473976243E-02_rk,  0.1423184359291447945477574401004914109E-01_rk/)
!
    real   (rk), parameter      :: a6(1_ik : 198_ik ) =              (/ &   ! 99 rows / 198 parameters
     0.3991591943524221943047733839385252063E-01_rk, -0.4320677984543984143119540132851021701E+00_rk,&
     0.1391632623209344004892677662009385027E+01_rk, -0.2398153301452575935813615941620667191E+01_rk,&
     0.2395231723378730355927914129141394923E+01_rk, -0.1526077846792219053580134885833695198E+01_rk,&
     0.9485565190988740214989072393805773970E+00_rk, -0.1606280969756716841559247784116454954E-01_rk,&
     0.3244371210551604946445374891246725112E+00_rk,  0.2613056664609149350751496472165057180E+00_rk,&
     0.4428049544215779756173291551248589054E-03_rk, -0.1904129992176202514054933903939078704E-02_rk,&
     0.4810524248551120347535289771244842580E-03_rk,  0.9814520997632892807772708621069976561E-01_rk,&
    -0.5815111864690066538829417445767730965E+00_rk,  0.1650526048999835773652140312428324898E+01_rk,&
    -0.2717092679695888951896089232835700346E+01_rk,  0.2681733559987225619987331287286964460E+01_rk,&
    -0.1715163438740012328028038944535721974E+01_rk,  0.1039552374305978077363837640636954431E+01_rk,&
    -0.4720345360127825236018292040825723299E-01_rk,  0.3316306613013396304783862278125846170E+00_rk,&
     0.2602985512350754543107724876422113481E+00_rk,  0.5074302329509942780121636670566437909E-03_rk,&
    -0.5583461352243069146529509598006922141E-03_rk, -0.1211407265009054615449641168031729612E-01_rk,&
     0.1521728875087944736234640888544292991E+00_rk, -0.7219707682528079445700634480341571120E+00_rk,&
     0.1897013842889145727671069576688530926E+01_rk, -0.3024689705396291524690592696925185441E+01_rk,&
     0.2961632243329672304301621137807719403E+01_rk, -0.1902288175816169108420931890905619684E+01_rk,&
     0.1130773107993228891636849183968768912E+01_rk, -0.7882612728427442702405415140567626054E-01_rk,&
     0.3390303353236577529604080310768919752E+00_rk,  0.2592491348310111672691738390929854864E+00_rk,&
     0.5756436421299692564388261443896879691E-03_rk,  0.6468953077129297611593180825895900230E-03_rk,&
    -0.2353837811343039574905351512065432979E-01_rk,  0.2018060638930092343662249476247255233E+00_rk,&
    -0.8526586920788124302877246969671302839E+00_rk,  0.2129291635952759261725298143341680606E+01_rk,&
    -0.3318266996744501804607981038765740304E+01_rk,  0.3232195679556175773778134843900167583E+01_rk,&
    -0.2085488924985502264585099629217495650E+01_rk,  0.1221224918399475553249493880130951950E+01_rk,&
    -0.1105838841113679560099484369883715674E+00_rk,  0.3465568033184452734867245803446376354E+00_rk,&
     0.2581680650010883241362903945795515346E+00_rk,  0.6468145967421047626438847381857912101E-03_rk,&
     0.1715184735362753463264744739177236436E-02_rk, -0.3379261587180708669186169741301865373E-01_rk,&
     0.2469193249449584922763670544344507507E+00_rk, -0.9729477322392991208296353436064145583E+00_rk,&
     0.2345790994645376898197115686444183432E+01_rk, -0.3595362563871748856472839977719220158E+01_rk,&
     0.3490799117438992062329356947644296993E+01_rk, -0.2262805925519205151549896257642814107E+01_rk,&
     0.1309878893012592992680744759846874780E+01_rk, -0.1421040472293559073073539367833427023E+00_rk,&
     0.3541214286101425236869714747025134538E+00_rk,  0.2570677744425228351183487336119148030E+00_rk,&
     0.7201668977172480052970758573813625140E-03_rk,  0.2651405040722461864215435392201239245E-02_rk,&
    -0.4289139066186052764597475738523495487E-01_rk,  0.2874490855917072045539937216901269055E+00_rk,&
    -0.1082365043678656743911045771334286772E+01_rk,  0.2545182491754138265769642633262301974E+01_rk,&
    -0.3853748883616055731319886558934705508E+01_rk,  0.3734953221120795658103641606978927235E+01_rk,&
    -0.2432305957450176224946159826649497669E+01_rk,  0.1395682821311337745489183409126414877E+01_rk,&
    -0.1729918380056928854146300733381913288E+00_rk,  0.3616268506726804797299007393162714000E+00_rk,&
     0.2559624640017740371789010943504239690E+00_rk,  0.7947739176508619601665266675488683707E-03_rk,&
     0.3461467094732043226802097721373257485E-02_rk, -0.5086117785856229786657530470110044549E-01_rk,&
     0.3233876982109495028833303855645574264E+00_rk, -0.1180584301593666213994877888670319434E+01_rk,&
     0.2726375095655102136118537945080220110E+01_rk, -0.4091447390122159798414142010762866599E+01_rk,&
     0.3962328870213559112101654555040983504E+01_rk, -0.2592104412836629703131948124079234159E+01_rk,&
     0.1477573169070249489222634451006665307E+01_rk, -0.2028343257866439404017578660568796733E+00_rk,&
     0.3689676916064367671450050608977900105E+00_rk,  0.2548680607741704116348562141523424828E+00_rk,&
     0.8695555717860707819012164257272122424E-03_rk,  0.4152070751259270519568817782314609034E-02_rk,&
    -0.5773843676960485747400275438672771073E-01_rk,  0.3547774518595292992458213486929729421E+00_rk,&
    -0.1267416557566842981443661889951532815E+01_rk,  0.2888512279002405545246592156891021603E+01_rk,&
    -0.4306738560549316619581351417448849349E+01_rk,  0.4170778540013840913141187553071165090E+01_rk,&
    -0.2740385996832834765985124815622027007E+01_rk,  0.1554487031486632225406668496677861743E+01_rk,&
    -0.2312046358763673266180488347461839256E+00_rk,  0.3760313861426504858403387861399496398E+00_rk,&
     0.2538021511413760165210145188997992991E+00_rk,  0.9432771970094396308106069498303820394E-03_rk,&
     0.4730491418524512492753179875217414716E-02_rk, -0.6356783823999347087337942631643242062E-01_rk,&
     0.3817045808420098098687035058387760864E+00_rk, -0.1342800122020465263885253399537141996E+01_rk,&
     0.3030965259033929007837993976544114520E+01_rk, -0.4498167834930694196629344936743525819E+01_rk,&
     0.4358354187802769744323773573537267785E+01_rk, -0.2875423829432753420112511847163612746E+01_rk,&
     0.1625373893475068884825888868311885390E+01_rk, -0.2576663510928701996182287558241875270E+00_rk,&
     0.3826991235329525573952313009481752355E+00_rk,  0.2527838891774308221897970381686818764E+00_rk,&
     0.1014550433995653204441036061940587040E-02_rk,  0.5204391696446424995454218582014977182E-02_rk,&
    -0.6840061986458489264776944694052370074E-01_rk,  0.4042933824851064592401453808332011269E+00_rk,&
    -0.1406789757761811482079898437532193073E+01_rk,  0.3153323782619137859143638688712355402E+01_rk,&
    -0.4664547656661549114977760262451188365E+01_rk,  0.4523321637747478605292981814271527551E+01_rk,&
    -0.2995596762790492563509343621524255967E+01_rk,  0.1689207038845144083617085621862752784E+01_rk,&
    -0.2817780419680394937527940354892479726E+00_rk,  0.3888468882507991159146152096299812987E+00_rk,&
     0.2518338812233640524391177037695726883E+00_rk,  0.1081836178969069108137692826881993786E-02_rk,&
     0.5581657154804616070428755064654739739E-02_rk, -0.7229307730529318680338387352425034402E-01_rk,&
     0.4227005263978795308527343293536570462E+00_rk, -0.1459545442282500057408227611368902210E+01_rk,&
     0.3255384861570335719228605427886778870E+01_rk, -0.4804955955889822129394844602643399560E+01_rk,&
     0.4664171516221356344774976385866404983E+01_rk, -0.3099404772279997730742337306227629158E+01_rk,&
     0.1744994465230696549548702180345089619E+01_rk, -0.3030978615266974710948066825816557074E+00_rk,&
     0.3943465852921412575344254638002028822E+00_rk,  0.2509740477748914421025977457326282658E+00_rk,&
     0.1143449642195532007740609857509695754E-02_rk,  0.5870255008644900298081885273787501007E-02_rk,&
    -0.7530519610874655816174484217248539960E-01_rk,  0.4371096211489741976047082147929947904E+00_rk,&
    -0.1501320928266328584405726028332369355E+01_rk,  0.3337139849101485234025894262307838772E+01_rk,&
    -0.4918731423118399448176539860733946986E+01_rk,  0.4779626841080831791129054595331083800E+01_rk,&
    -0.3185482321128456585460996357339075076E+01_rk,  0.1791789178091498987517058547745173991E+01_rk,&
    -0.3211881424886091959614224585172342854E+00_rk,  0.3990672350157656265585039381140582816E+00_rk,&
     0.2502274641425169546114379664213189772E+00_rk,  0.1197567520820166417462856881320885591E-02_rk,&
     0.6078114220454002794167833139891830409E-02_rk, -0.7749942498036679917452560985521072842E-01_rk,&
     0.4477260893388074469362368993412731685E+00_rk, -0.1532452303284844035671795878438692305E+01_rk,&
     0.3398760228077520070402987180799728979E+01_rk, -0.5005465935601536714628229366292694069E+01_rk,&
     0.4868647412471784867100054073472424394E+01_rk, -0.3252609637879854474082047657160927000E+01_rk,&
     0.1828698754406626367015165348397296034E+01_rk, -0.3356199375619678800932624369886540212E+00_rk,&
     0.4028762219043476588062932707189686537E+00_rk,  0.2496181816244883664112071792595398960E+00_rk,&
     0.1242237264540583489799742567075531661E-02_rk,  0.6213025409510897975657558640305130554E-02_rk,&
    -0.7893958864375574838610769352949856524E-01_rk,  0.4547723885767430626125177530680250513E+00_rk,&
    -0.1553346721604355992200112224148274658E+01_rk,  0.3440582457171766717536522171327654364E+01_rk,&
    -0.5064994505701460445768591357129097776E+01_rk,  0.4930431189177822780821490738969025742E+01_rk,&
    -0.3299721882592001351311882677739859263E+01_rk,  0.1854894084404378852166055053441431182E+01_rk,&
    -0.3459774471053927407541989090010606900E+00_rk,  0.4056405813449272544678727590378548902E+00_rk,&
     0.2491710311774905358632659023602524088E+00_rk,  0.1275388384326096655512529183639509175E-02_rk,&
     0.6282558864674286923448528240185466291E-02_rk, -0.7968993614560657402881101609012079619E-01_rk,&
     0.4584836039254401465313643248203144428E+00_rk, -0.1564471453941171719029169506754997967E+01_rk,&
     0.3463092193436052316889809998129007244E+01_rk, -0.5097383119370586255752828099038848745E+01_rk,&
     0.4964412863614070402698938014476777966E+01_rk, -0.3325916211147931246733420019737561578E+01_rk,&
     0.1869617217448701795362042871989747257E+01_rk, -0.3518622826938906090275950703609291809E+00_rk,&
     0.4072283085072305352918135139679939309E+00_rk,  0.2489114117756239134074038276549583116E+00_rk,&
     0.1294845727393006336078813096773115744E-02_rk,  0.6293998926013258465438142095992667322E-02_rk,&
    -0.7981431869878287386596443049426271509E-01_rk,  0.4591034269361875766907394628743265547E+00_rk,&
    -0.1566343375307466911489173653765140898E+01_rk,  0.3466908180151316182522695961730132060E+01_rk/)
!
    real   (rk), parameter      :: a7(1_ik : 112_ik ) =              (/ &   ! 56 rows / 112 parameters
    -0.5102914825444519646918665106535168029E+01_rk,  0.4970259870689946241396623837032183565E+01_rk,&
    -0.3330456777097502509395323378744057725E+01_rk,  0.1872188255692904568940580787744916786E+01_rk,&
    -0.3528975198995949434006520503277851803E+00_rk,  0.4075096736212710563345727260206785183E+00_rk,&
     0.2488650658139236101954589078345516311E+00_rk,  0.1298344616304394571550084248697169846E-02_rk,&
     0.6254293012657212309008868931083063910E-02_rk, -0.7937548983166651923043334460615304050E-01_rk,&
     0.4568805274244099940679858598398218064E+00_rk, -0.1559518987100913196668629939489611411E+01_rk,&
     0.3452766058094752298633982180058945090E+01_rk, -0.5082074423546457725805318387241829758E+01_rk,&
     0.4947866081386501170905162720661390500E+01_rk, -0.3312777736873226065476012615649303460E+01_rk,&
     0.1862011256030182740054385633247092949E+01_rk, -0.3487314987613174570989906058843271605E+00_rk,&
     0.4063585284003006260882443644716177621E+00_rk,  0.2490578440380698224370544205765923809E+00_rk,&
     0.1283547726707101318904369951000796525E-02_rk,  0.6170013619777860836918991907381025003E-02_rk,&
    -0.7843451967335289876235344628604598115E-01_rk,  0.4520653165513390308304729793714175101E+00_rk,&
    -0.1544585047521861219715059915256433660E+01_rk,  0.3421502327327472009461006805399891663E+01_rk,&
    -0.5035532081139564823024349001398998573E+01_rk,  0.4897343441562654167565300481812770045E+01_rk,&
    -0.3272484346978541370343595994651904368E+01_rk,  0.1838579116975054929376598538306121663E+01_rk,&
    -0.3390413358451574318105209255338330034E+00_rk,  0.4036535889976370672940926180146349064E+00_rk,&
     0.2495154625674226742369047896468100741E+00_rk,  0.1248063557120004392423309927805715083E-02_rk,&
     0.6047331678661685427919314253314819803E-02_rk, -0.7705031459713030632497920098745354118E-01_rk,&
     0.4449070934946942908003731138908762393E+00_rk, -0.1522149864383553115147529317948347581E+01_rk,&
     0.3374038655940164037240565725124105200E+01_rk, -0.4964126189578270969801199615917320429E+01_rk,&
     0.4819011820810661464697851613964990934E+01_rk, -0.3209352260843556236796724108253508703E+01_rk,&
     0.1801477442203470401499621640370221686E+01_rk, -0.3235361173768180790041567890317800887E+00_rk,&
     0.3992796817009590738380636959008021845E+00_rk,  0.2502632546251560592087155796159322441E+00_rk,&
     0.1189466325561694409424721866225690923E-02_rk,  0.5891999763466294518613204942716951864E-02_rk,&
    -0.7527923311759906643416075663913349939E-01_rk,  0.4356515629040177053488278959433081446E+00_rk,&
    -0.1492835286473865653494748602992672831E+01_rk,  0.3311366702437461600402770480317201679E+01_rk,&
    -0.4868845745781931334280416204155928604E+01_rk,  0.4713387335740043799772191519855796819E+01_rk,&
    -0.3123325148570282461990878039850876093E+01_rk,  0.1750387386408350207304327059187013445E+01_rk,&
    -0.3019597485495694813123526370029829764E+00_rk,  0.3931289385293717879521561494076083410E+00_rk,&
     0.2513259195987245177671917454053655330E+00_rk,  0.1105317111812084450561465273938658558E-02_rk,&
     0.5709343730622972997809100561028906860E-02_rk, -0.7317478884239429447196903163758119176E-01_rk,&
     0.4245387063335813325008148347135937054E+00_rk, -0.1457269413833530552847172029876064608E+01_rk,&
     0.3234533590026618174850189205115502314E+01_rk, -0.4750812521179168472386040294005147598E+01_rk,&
     0.4581169407503578885409576610227579869E+01_rk, -0.3014510774892740165378976694400227681E+01_rk,&
     0.1685087501778581804056363753341739992E+01_rk, -0.2740934396851412492599262583576170821E+00_rk,&
     0.3851019309808138443686067343771713031E+00_rk,  0.2527272720283298842355657478000790048E+00_rk,&
     0.9931860508478359253284776443917043486E-03_rk,  0.5504261487069225380460222017695295090E-02_rk,&
    -0.7078743137471964126995928798433145273E-01_rk,  0.4118009878130495324411518039600505090E+00_rk,&
    -0.1416080033590789260041291029104776427E+01_rk,  0.3144628144332646732992675224054536299E+01_rk,&
    -0.4611263253553732843538986719348062463E+01_rk,  0.4423226805303345481045034787428468722E+01_rk,&
    -0.2883175679549694141394219891936940985E+01_rk,  0.1605454614707270738950906062440583213E+01_rk,&
    -0.2397578153644824311856847182575633519E+00_rk,  0.3751087313544826401167884017892133386E+00_rk,&
     0.2544899930630226895994759030367571967E+00_rk,  0.8506753725312769036514298675871481728E-03_rk,&
     0.5281227697567127580295435284890159212E-02_rk, -0.6816439630920158659684981947981515374E-01_rk,&
     0.3976618715392852231551567578400774303E+00_rk, -0.1369888776254498759966913162277345174E+01_rk,&
     0.3042767981229374300031341737652870567E+01_rk, -0.4451532070978348555062556389706358316E+01_rk,&
     0.4240582916623352005435559640243304417E+01_rk, -0.2729738610137535001675108604995720101E+01_rk,&
     0.1511463772237475412319197289184600158E+01_rk, -0.1988146378789192997309916314959387028E+00_rk,&
     0.3630698923200153701046507993450980039E+00_rk,  0.2566353868364589055906197096354885217E+00_rk,&
     0.6754430749748588155982411510738174362E-03_rk,  0.5044303356064812481814574526550537832E-02_rk,&
    -0.6534961582683515498379029430353967109E-01_rk,  0.3823346282409684247161024211453332932E+00_rk,&
    -0.1319305977507712172812165073903582617E+01_rk,  0.2930087508713219155636028706591156757E+01_rk,&
    -0.4273033330679165508526880750708127688E+01_rk,  0.4034400471592241110703281523512405929E+01_rk,&
    -0.2554762860631765315713975835981660656E+01_rk,  0.1403187306248885073157022898468598647E+01_rk,&
    -0.1511681413187648536981581676147987083E+00_rk,  0.3489173366984985441386688799630780668E+00_rk,&
     0.2591831441002530775094842833598589741E+00_rk,  0.4652270141128073925668349447274942782E-03_rk/)
!
!-----------------------------------------------------------------------------------------------------
!
!   parameter 1301 to 1480 for kind=2 (dp) coefficients in b1
!
    real   (rk), parameter      :: b1(1_ik : 180_ik ) =              (/ &   ! 90 rows / 180 parameters
    -0.5305637435791657307761648374066942938E-01_rk, -0.3837388157037034412172396206038076469E-01_rk,&
     0.1584175931178942490480695115848771465E-01_rk,  0.9625999155325438116752780910789496984E-01_rk,&
     0.1772801598479270817987384237249043160E+00_rk,  0.2382011957042947169036541713843429361E+00_rk,&
     0.2686617064497743190133693760803820532E+00_rk,  0.2686617064513192541230889568130330627E+00_rk,&
    -0.1198830117681258455229647740277962529E-16_rk, -0.5222244249540125891049365092180342786E-01_rk,&
    -0.3904562537254336975764850079288577224E-01_rk,  0.1602543986494553253238682069756416651E-01_rk,&
     0.9623375242856826135792824036966738446E-01_rk,  0.1772824102227009262090573694910446609E+00_rk,&
     0.2382010746603674878225311764056500356E+00_rk,  0.2686617104733232457196089968610599932E+00_rk,&
     0.2686617063754370786266090840495284106E+00_rk,  0.6228154039737202783217249063663167749E-12_rk,&
    -0.3789593791846069573065122396277056415E-01_rk, -0.5101492431570284007260352544039998155E-01_rk,&
     0.2046074359645540700307927452292713880E-01_rk,  0.9528293242911730319878982549228457477E-01_rk,&
     0.1774111994486380074337635653381944900E+00_rk,  0.2381898044358471576096274677470443005E+00_rk,&
     0.2686623318438223705809065970057911159E+00_rk,  0.2686616866668323464145304615040483015E+00_rk,&
     0.2756413365016289341491985066478698088E-09_rk, -0.8438486549516461214408135773201099319E-02_rk,&
    -0.8682549502923621312604888390202242314E-01_rk,  0.3964238937356049008667364498552032622E-01_rk,&
     0.8937166487965295354210405321486210881E-01_rk,  0.1785571404546438939841467961294964513E+00_rk,&
     0.2380467645307243090028571985342620736E+00_rk,  0.2686735540094160766427579104944045360E+00_rk,&
     0.2686611809527307723945491771740243564E+00_rk,  0.1029311653298245101651915671413744512E-07_rk,&
     0.3146503414576953393970491101705605800E-01_rk, -0.1508727959016437858824348634452500140E+00_rk,&
     0.8480384128933616262695336445157752927E-01_rk,  0.7110051903570397877900537968457426911E-01_rk,&
     0.1831955601012050230193283006353217216E+00_rk,  0.2372902325379488776812754679514484652E+00_rk,&
     0.2687509600687087503093239364053602656E+00_rk,  0.2686566391888011317302409961784250476E+00_rk,&
     0.1272742241033196395679761579532573678E-06_rk,  0.7171006834705760344977152720674877796E-01_rk,&
    -0.2311773553880540964322480016143152516E+00_rk,  0.1550965375831768246537882873175624532E+00_rk,&
     0.3584713508718588246128747318832932852E-01_rk,  0.1942750373491096327617627208744627876E+00_rk,&
     0.2350558914100843004296323170814446961E+00_rk,  0.2690332988300052967843453275104665834E+00_rk,&
     0.2686362011713292000989864732866752926E+00_rk,  0.7761189385725004127541612301447233909E-06_rk,&
     0.1008578390945704288037228343651543340E+00_rk, -0.3006027689402806605976767975702530370E+00_rk,&
     0.2275741780068071672938265061510612372E+00_rk, -0.7469071564158203982118534069275150202E-02_rk,&
     0.2104848319096248487253495891081306255E+00_rk,  0.2311664743636043342396384332390653619E+00_rk,&
     0.2696176421538984086768787439555439416E+00_rk,  0.2685859432846689574607283412094010000E+00_rk,&
     0.2670645100120195258118558698426337545E-05_rk,  0.1111200536180662222376286919281254053E+00_rk,&
    -0.3286504715113585814178919827280053583E+00_rk,  0.2611400578750138223581819568354816361E+00_rk,&
    -0.3044305689502584308196777346172244881E-01_rk,  0.2203212953158148452635073747961925916E+00_rk,&
     0.2284686469523598733062317841210939535E+00_rk,  0.2700805234886862660219471652591856241E+00_rk,&
     0.2685405183177558678631582194429537418E+00_rk,  0.4622788511465251666544938001147726721E-05_rk,&
     0.1011441985818429042349344899924779434E+00_rk, -0.2961061267669225558597148182982565506E+00_rk,&
     0.2146613385867335730793641083003949854E+00_rk,  0.7511444900563517135657016805284692157E-02_rk,&
     0.2009385945547393079405928342211000268E+00_rk,  0.2348073476069316758766294978355540950E+00_rk,&
     0.2687841974588002616820535196738527429E+00_rk,  0.2686920945801622519747642644291741469E+00_rk,&
    -0.3135396333173763759972950766294089238E-05_rk,  0.7546487607004219366768173858490507651E-01_rk,&
    -0.2032599848916299385189771795165536300E+00_rk,  0.6767751752514413653196247917110457768E-01_rk,&
     0.1405818417507370222845512655225457221E+00_rk,  0.1255832236933298088667654323517178609E+00_rk,&
     0.2621388723774732060589110146207532937E+00_rk,  0.2625837058891569124556187106545815188E+00_rk,&
     0.2694965059757764091168611905043053788E+00_rk, -0.4882644924600121572862461501854765409E-04_rk,&
     0.4174146464881357077304700126050976515E-01_rk, -0.6823586765674149192333896612860420072E-01_rk,&
    -0.1690013839143034393630728343530473121E+00_rk,  0.3778060442379302574729747379180238010E+00_rk,&
    -0.2312207050488710736531317500362770158E-01_rk,  0.3218369217325570018528648719431245291E+00_rk,&
     0.2475952057019386471048497124593506102E+00_rk,  0.2716482973797000850535517478284392128E+00_rk,&
    -0.1840647191670041595127587250683338216E-03_rk,  0.7691056030979109821944586967512983936E-02_rk,&
     0.8148655149211163639145124946356453858E-01_rk, -0.4571860542826017374080981589309952396E+00_rk,&
     0.6949512692300020034075314640498301062E+00_rk, -0.2413781767144476635671736195984863942E+00_rk,&
     0.4180191575783795201105238681875562096E+00_rk,  0.2210892944058591311599947311042054599E+00_rk,&
     0.2758245892623634919438987166742204883E+00_rk, -0.4721054807610634165151074689034379370E-03_rk,&
    -0.2096701738229553761105789524211184539E-01_rk,  0.2188013784453314322134326496812816988E+00_rk,&
    -0.7451702281009952281805137415052704568E+00_rk,  0.1040241824189834255432211622222013872E+01_rk,&
    -0.5002494216036722186701802367849419075E+00_rk,  0.5422890233769551800072241326924993092E+00_rk,&
     0.1837874303428325964429530266409797670E+00_rk,  0.2822257603694700648965468164193623589E+00_rk,&
    -0.9529094506464325564128469726326325020E-03_rk, -0.4122632230935160866741250848210720775E-01_rk,&
     0.3238504701921587668979179457248482851E+00_rk, -0.9835719477804169169249776356198515399E+00_rk,&
     0.1349527780650505958428332276924410806E+01_rk, -0.7511277907570169102754852515333327986E+00_rk,&
     0.6725812990200966683422079793654964750E+00_rk,  0.1414790155118950465742251432844371708E+00_rk,&
     0.2900793723040933132665135519257768122E+00_rk, -0.1590971239815892028990175274791628633E-02_rk,&
    -0.5250295902134002627096379907396355369E-01_rk,  0.3867135932166782585340493811020162649E+00_rk,&
    -0.1136939455758476262421475627948163679E+01_rk,  0.1563410905331922440641253390827947685E+01_rk,&
    -0.9376129296056066853999539416396607311E+00_rk,  0.7766780297603826509523518560905984013E+00_rk,&
     0.1051498255860250108423302367373592085E+00_rk,  0.2973267769847283933114922126966162513E+00_rk,&
    -0.2223723904609892711353081282360864580E-02_rk, -0.5586770455719527961617197696369301035E-01_rk,&
     0.4066696926123379583601758209834560015E+00_rk, -0.1188730546727388455578599451547125103E+01_rk,&
     0.1640231088655139968196419553566304951E+01_rk, -0.1008841719349653100499376326883505334E+01_rk,&
     0.8189543013930763035726783685531279713E+00_rk,  0.8946427765567384140689835858015632010E-01_rk,&
     0.3006529703499067962800457233893833936E+00_rk, -0.2532367388843335650056315638560218712E-02_rk,&
    -0.5322417784743254079130624704407131319E-01_rk,  0.3895877990658030153934691010204991035E+00_rk,&
    -0.1140431805378855647497792827774733036E+01_rk,  0.1562182289656189066254181794245873039E+01_rk,&
    -0.9300020996650459071804364672463951156E+00_rk,  0.7679778198108433720434947127796084652E+00_rk,&
     0.1100677996750577758526552345611482872E+00_rk,  0.2958936990539258779555473437767891013E+00_rk,&
    -0.2051326357894020113156852210932177475E-02_rk, -0.4666210612955597705130074624298706178E-01_rk,&
     0.3448694438571105113253453022917355747E+00_rk, -0.1007077549656695919120907514496647844E+01_rk,&
     0.1334888449218741051236241820507428827E+01_rk, -0.6878178838268321352085885303305829258E+00_rk,&
     0.6027889083812465919326673454567218643E+00_rk,  0.1805034279456175138360375831011317734E+00_rk,&
     0.2787279898251297796847096363362244400E+00_rk, -0.2206797398329750213567246692776651542E-03_rk,&
    -0.3805229221665690090792611874202756347E-01_rk,  0.2828380805607086987435567776947850103E+00_rk,&
    -0.8115100033912019343451461428588136923E+00_rk,  0.9824900729549051806804890869412944647E+00_rk,&
    -0.2908635462221021087379412839381146665E+00_rk,  0.3165580222581908848140828341330928479E+00_rk,&
     0.3095247628429173848708471475921714423E+00_rk,  0.2454882725595563578191164833097986767E+00_rk,&
     0.3526630652504424039372529228258790160E-02_rk, -0.2885573505905234251163806014581433262E-01_rk,&
     0.2129442230060942958501333064519500832E+00_rk, -0.5790694474817265561063622183382824175E+00_rk,&
     0.5406879405673789213494430559172691400E+00_rk,  0.2340704634836007998728028247641567463E+00_rk,&
    -0.8268972343860736418972495917635944799E-01_rk,  0.4993443435907147536992471290836126505E+00_rk,&
     0.1939081815837882132982794398808239919E+00_rk,  0.9659753747809278436304545165788317993E-02_rk/)
!
!-----------------------------------------------------------------------------------------------------
!
!   parameter 1481 to 1580 for kind=1 (sp) coefficients in c1
!
    real   (rk), parameter      :: c1(1_ik : 100_ik ) =              (/ &   ! 50 rows / 100 parameters
     0.1907256638108940360876175645898911171E+00_rk,  0.2375174333591498487816551232754136436E+00_rk,&
     0.2686772279624419224042242149153025821E+00_rk,  0.2686615544862553939253757562255486846E+00_rk,&
     0.4925489160308992178431643140651408075E-09_rk,  0.2140180756716819898688441980993957259E+00_rk,&
     0.2327547716728236293359799446989200078E+00_rk,  0.2690586886607151395622850031941197813E+00_rk,&
     0.2686474611017765634635168225941015407E+00_rk,  0.2013593161047739834259613514802489398E-06_rk,&
     0.2375852996033814001908268664919887669E+00_rk,  0.2233593454279042267440757996155298315E+00_rk,&
     0.2704816236871219747861516680131899193E+00_rk,  0.2685504722093675078475882855855161324E+00_rk,&
     0.2709716582498531706196679205711497218E-05_rk,  0.2580581614283757319050494061229983345E+00_rk,&
     0.2111442681783651797999823429563548416E+00_rk,  0.2732304821029105657004265594878233969E+00_rk,&
     0.2682739579610887714622435851197224110E+00_rk,  0.1319913809896399496072050966377631198E-04_rk,&
     0.2729762875171295455345443770056590438E+00_rk,  0.1993195172016242189272361429175361991E+00_rk,&
     0.2767565500356505836521137098316103220E+00_rk,  0.2678051355672852462674882190185599029E+00_rk,&
     0.3664997768635277602391683848814807334E-04_rk,  0.2798096556043654370427020694478414953E+00_rk,&
     0.1926350840760904514770146533919614740E+00_rk,  0.2792126244323921979706426554912468418E+00_rk,&
     0.2674033640128641309274826198816299438E+00_rk,  0.6133967267894428851849469852552942939E-04_rk,&
     0.2763592599958406004212463358271634206E+00_rk,  0.1969549777216280939118320247871452011E+00_rk,&
     0.2771851874083191558106875618250342086E+00_rk,  0.2678261216840865932553583661501761526E+00_rk,&
     0.2829276217779641414747787697692160691E-04_rk,  0.2611589393322080177028965408680960536E+00_rk,&
     0.2184307612134712972551398024734226055E+00_rk,  0.2657959598427636072059954130963888019E+00_rk,&
     0.2705131116842409699785321208764798939E+00_rk, -0.2096478407069709518507211187809957664E-03_rk,&
     0.2337673136966987585960708884158520959E+00_rk,  0.2624507151033372287507461351196980104E+00_rk,&
     0.2392465997729810167626851580280344933E+00_rk,  0.2776353039139325407091973829665221274E+00_rk,&
    -0.9266786876374595669642042494729139435E-03_rk,  0.1948731020690228910030583620027755387E+00_rk,&
     0.3326337508260251984992805773799773306E+00_rk,  0.1917256418603754120066895438867504708E+00_rk,&
     0.2919449351883651178063416864461032674E+00_rk, -0.2543542337886044429201559680109312467E-02_rk,&
     0.1461986096671687995751653943443670869E+00_rk,  0.4301213938500386690932941746723372489E+00_rk,&
     0.1184679749109510404903033986556692980E+00_rk,  0.3164241346316367109459122275438858196E+00_rk,&
    -0.5612525161952996305414487210327934008E-02_rk,  0.9024397985593513027424705796875059605E-01_rk,&
     0.5533155630645764100350447733944747597E+00_rk,  0.1671163502401512221395840640525420895E-01_rk,&
     0.3537952186676715515822877478058217093E+00_rk, -0.1076156039719514991015447691324879997E-01_rk,&
     0.2994707409003677031633650074127217522E-01_rk,  0.6980732902155528663001859968062490225E+00_rk,&
    -0.1136579607266862551595565378192986827E+00_rk,  0.4059969208756930014736497014382621273E+00_rk,&
    -0.1860271762259948016837718398619472282E-01_rk, -0.3166370937817009761916509091861371417E-01_rk,&
     0.8582587843981110964364233950618654490E+00_rk, -0.2698843753500866360361953866231488064E+00_rk,&
     0.4737355913140772756264595955144613981E+00_rk, -0.2962022495254971674039090601127099944E-01_rk,&
    -0.9176491331650163396638220092427218333E-01_rk,  0.1026497173307640897732539997377898544E+01_rk,&
    -0.4465343246301466950676228861993877217E+00_rk,  0.5561939343957372772209168942936230451E+00_rk,&
    -0.4405805858558924786860799827081791591E-01_rk, -0.1479496971627063117704636852067778818E+00_rk,&
     0.1194972014947779603843969198351260275E+01_rk, -0.6360229037674235419430601723433937877E+00_rk,&
     0.6509373199344604676852554803190287203E+00_rk, -0.6182637930178212781751057036672136746E-01_rk,&
    -0.1983481866925670411561100081598851830E+00_rk,  0.1356142284716036039426967363397125155E+01_rk,&
    -0.8293406815245669694292018903070129454E+00_rk,  0.7540149389080638142601742401893716305E+00_rk,&
    -0.8244105377170540815967569869826547801E-01_rk, -0.2416662526526037746421593510603997856E+00_rk,&
     0.1503302622703608593113244751293677837E+01_rk, -0.1016849544814026229389014588377904147E+01_rk,&
     0.8602207867339743962986631231615319848E+00_rk, -0.1050034123059535029476307954610092565E+00_rk,&
    -0.2771615364474883658196802116435719654E+00_rk,  0.1630956786377221412465132743818685412E+01_rk,&
    -0.1189036429839941177988293929956853390E+01_rk,  0.9634617923486022972312525780580472201E+00_rk,&
    -0.1282203702816096524408351342572132125E+00_rk, -0.3045779330446333754700560803030384704E+00_rk,&
     0.1735009600458857992322236896143294871E+01_rk, -0.1337148586632413094221760729851666838E+01_rk,&
     0.1057176410920674269888763774360995740E+01_rk, -0.1504594916461773623783670927878119983E+00_rk/)
!
!-----------------------------------------------------------------------------------------------------
!
!   parameter 1 to 1580 for kind=1 (sp), kind=2 (dp) and kind=3 (ep/qp) coefficients to vector cff
!
    real(rk), parameter :: cff(1_ik:1580_ik) = reshape(  (/ a1, a2, a3, a4, a5, a6, a7, b1, c1 /),  &
                                                         (/              1580_ik               /)   )
!
!-----------------------------------------------------------------------------------------------------
!